/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.common.utils;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.UUID;
import org.gcube.application.geoportal.common.rest.TempFile;
import org.gcube.application.geoportal.common.utils.ContextUtils;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageUtils {
    private static final Logger log = LoggerFactory.getLogger(StorageUtils.class);
    private IClient client = StorageUtils.getClient();

    public static final IClient getClient() {
        return new StorageClient("Application", "GeoPortal", ContextUtils.getCurrentCaller(), AccessType.SHARED, MemoryType.VOLATILE).getClient();
    }

    public TempFile putOntoStorage(InputStream source, String filename) throws RemoteBackendException, FileNotFoundException {
        log.debug("Uploading source " + filename);
        String id = this.client.put(true).LFile(source).RFile(StorageUtils.getUniqueString());
        return new TempFile(id, filename);
    }

    public static final boolean checkStorageId(String id) {
        return StorageUtils.getClient().getHttpUrl().RFile(id) != null;
    }

    public static final String getUrlById(String id) {
        IClient client = StorageUtils.getClient();
        log.debug("Id is " + id);
        return client.getHttpUrl().RFile(id);
    }

    public static final void removeById(String id) {
        IClient client = StorageUtils.getClient();
        client.remove().RFile(id);
    }

    public static final String getUniqueString() {
        return UUID.randomUUID().toString();
    }
}

