package org.gcube.application.geoportal.common.model.rest;

import lombok.Data;

import java.util.List;

@Data
public class QueryRequest {

    @Data
    public static class PagedRequest{
        private int offset;
        private int Limit;
    }

    @Data
    public static class OrderedRequest {
        public static enum Direction {ASCENDING,DESCENDING}
        private Direction direction;
        private String json;
        private List<String> fields;
    }
    private String filter;
    private String transformation;
    private OrderedRequest ordering;
    private PagedRequest paging;
}
