package org.gcube.application.geoportal.common.model.document;

import com.mongodb.client.model.geojson.GeoJsonObjectType;
import lombok.*;
import org.bson.Document;


@NoArgsConstructor
@AllArgsConstructor
@Getter
@Setter
@ToString
public class ProfiledDocument {
    // CORE METADATA

    private String _id;
    private ComparableVersion version;

    // Publication Info

    private PublicationInfo info;

    // Profile reference

    private String profileID;
    private ComparableVersion profileVersion;

    private LifecycleInformation lifecycleInformation;

    private Relationship[] relationships;

    private GeoJsonObjectType spatialReference;

    private TemporalReference temporalReference;

    private Document theDocument;

}
