/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportalcommon;

import java.io.StringReader;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.gcube.application.geoportalcommon.shared.GeoNaDataViewerProfile;
import org.gcube.application.geoportalcommon.shared.LayerItem;
import org.gcube.application.geoportalcommon.shared.exception.ApplicationProfileNotFoundException;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GeoNaDataViewerProfileReader {
    private static final String RESOURCE_PROFILE_BODY = "/Resource/Profile/Body";
    public static final String SECONDARY_TYPE = "ApplicationProfile";
    public static final String WORKSPACE_EXPLORER_APP_NAME = "GeoNa-Viewer-Profile";
    private Logger logger = LoggerFactory.getLogger(GeoNaDataViewerProfileReader.class);
    private String secondaryType;
    private String scope;
    private String appID;

    public GeoNaDataViewerProfileReader(String appID) {
        this.appID = appID;
        this.secondaryType = SECONDARY_TYPE;
        this.scope = ScopeProvider.instance.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoNaDataViewerProfile readProfileFromInfrastrucure() throws Exception {
        String queryString = GeoNaDataViewerProfileReader.getGcubeGenericQueryString(this.secondaryType, this.appID);
        this.logger.info("Scope " + this.scope + ", trying to perform query: " + queryString);
        try {
            if (this.scope == null) {
                throw new Exception("Scope is null, set scope into ScopeProvider");
            }
            GeoNaDataViewerProfile profile = new GeoNaDataViewerProfile();
            this.logger.info("Trying to fetch ApplicationProfile in the scope: " + this.scope + ", SecondaryType: " + this.secondaryType + ", AppId: " + this.appID);
            QueryBox q = new QueryBox(queryString);
            DiscoveryClient client = ICFactory.client();
            List appProfile = client.submit((Query)q);
            if (appProfile == null || appProfile.size() == 0) {
                throw new ApplicationProfileNotFoundException("ApplicationProfile with SecondaryType: " + this.secondaryType + ", AppId: " + this.appID + " is not registered in the scope: " + this.scope);
            }
            String elem = (String)appProfile.get(0);
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docBuilder.parse(new InputSource(new StringReader(elem)));
            XPathHelper helper = new XPathHelper((Node)doc.getDocumentElement());
            List currValue = null;
            String xPathExp = "/Resource/Profile/Body/RestrictedPortletURL/text()";
            currValue = helper.evaluate(xPathExp);
            if (currValue == null || currValue.size() <= 0) {
                throw new Exception("I'm not able to read the path: " + xPathExp);
            }
            profile.setRestrictedPortletURL((String)currValue.get(0));
            xPathExp = "/Resource/Profile/Body/OpenPortletURL/text()";
            currValue = helper.evaluate(xPathExp);
            if (currValue == null || currValue.size() <= 0) {
                throw new Exception("I'm not able to read the path: " + xPathExp);
            }
            profile.setOpenPortletURL((String)currValue.get(0));
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.compile("/Resource/Profile/Body/AvailableLayers/Layer").evaluate(doc, XPathConstants.NODESET);
            HashMap<String, LayerItem> mapLayers = new HashMap<String, LayerItem>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node layerNode = nodeList.item(i);
                if (layerNode.getNodeType() != 1) continue;
                Element eElement = (Element)layerNode;
                String layerType = eElement.getElementsByTagName("Type").item(0).getTextContent();
                String wmsLink = eElement.getElementsByTagName("WMSLink").item(0).getTextContent();
                String decodedURL = URLDecoder.decode(wmsLink, "UTF-8");
                LayerItem layer = new LayerItem();
                layer.setWmsLink(decodedURL);
                mapLayers.put(layerType.toLowerCase(), layer);
            }
            profile.setMapLayers(mapLayers);
            this.logger.info("returning: " + profile);
            GeoNaDataViewerProfile geoNaDataViewerProfile = profile;
            return geoNaDataViewerProfile;
        }
        catch (Exception e) {
            this.logger.error("Error while trying to read the  ApplicationProfile with SecondaryType GeoNa-Viewer-Profile from scope " + this.scope, (Throwable)e);
            GeoNaDataViewerProfile geoNaDataViewerProfile = null;
            return geoNaDataViewerProfile;
        }
    }

    public static String getGcubeGenericQueryString(String secondaryType, String appId) {
        return "for $profile in collection('/db/Profiles/GenericResource')//Resource where $profile/Profile/SecondaryType/string() eq '" + secondaryType + "' and  $profile/Profile/Body/AppId/string()  eq '" + appId + "'return $profile";
    }

    public String getSecondaryType() {
        return this.secondaryType;
    }

    public String getScope() {
        return this.scope;
    }

    public String toString() {
        return "GeoNaViewerProfileReader [secondaryType=" + this.secondaryType + ", scope=" + this.scope + ", appID=" + this.appID + "]";
    }
}

