package org.gcube.application.geoportalcommon.shared.products.model;

import java.io.Serializable;
import java.util.List;

import org.gcube.application.geoportalcommon.shared.gis.BoundsMap;
import org.gcube.application.geoportalcommon.shared.products.BaseConcessioneDV;

/**
 * The Class LayerConcessioneDV.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR francesco.mangiacrapa@isti.cnr.it
 * 
 * Sep 9, 2021
 */
public class LayerConcessioneDV extends SDILayerDescriptorDV implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2633250621043744245L;

	// 1.Identificazione
	private String abstractSection;

	// 2.Classificazione
	private String topicCategory;

	// 3.Keyword
	private String subTopic;

	// 4. Delimitazione geographica
	private BoundsMap bbox;

	// 5. Temporal

	// 6. Quality
	private String valutazioneQualita;

	private String metodoRaccoltaDati;

	private String scalaAcquisizione;

	private List<String> authors;

	private BaseConcessioneDV refersTo;

	/**
	 * Instantiates a new layer concessione DV.
	 */
	public LayerConcessioneDV() {

	}

	/**
	 * Gets the abstract section.
	 *
	 * @return the abstract section
	 */
	public String getAbstractSection() {
		return abstractSection;
	}

	/**
	 * Sets the abstract section.
	 *
	 * @param abstractSection the new abstract section
	 */
	public void setAbstractSection(String abstractSection) {
		this.abstractSection = abstractSection;
	}

	/**
	 * Gets the topic category.
	 *
	 * @return the topic category
	 */
	public String getTopicCategory() {
		return topicCategory;
	}

	/**
	 * Sets the topic category.
	 *
	 * @param topicCategory the new topic category
	 */
	public void setTopicCategory(String topicCategory) {
		this.topicCategory = topicCategory;
	}

	/**
	 * Gets the sub topic.
	 *
	 * @return the sub topic
	 */
	public String getSubTopic() {
		return subTopic;
	}

	/**
	 * Sets the sub topic.
	 *
	 * @param subTopic the new sub topic
	 */
	public void setSubTopic(String subTopic) {
		this.subTopic = subTopic;
	}

	/**
	 * Gets the bbox.
	 *
	 * @return the bbox
	 */
	public BoundsMap getBbox() {
		return bbox;
	}

	/**
	 * Sets the bbox.
	 *
	 * @param bbox the new bbox
	 */
	public void setBbox(BoundsMap bbox) {
		this.bbox = bbox;
	}

	/**
	 * Gets the valutazione qualita.
	 *
	 * @return the valutazione qualita
	 */
	public String getValutazioneQualita() {
		return valutazioneQualita;
	}

	/**
	 * Sets the valutazione qualita.
	 *
	 * @param valutazioneQualita the new valutazione qualita
	 */
	public void setValutazioneQualita(String valutazioneQualita) {
		this.valutazioneQualita = valutazioneQualita;
	}

	/**
	 * Gets the metodo raccolta dati.
	 *
	 * @return the metodo raccolta dati
	 */
	public String getMetodoRaccoltaDati() {
		return metodoRaccoltaDati;
	}

	/**
	 * Sets the metodo raccolta dati.
	 *
	 * @param metodoRaccoltaDati the new metodo raccolta dati
	 */
	public void setMetodoRaccoltaDati(String metodoRaccoltaDati) {
		this.metodoRaccoltaDati = metodoRaccoltaDati;
	}

	/**
	 * Gets the scala acquisizione.
	 *
	 * @return the scala acquisizione
	 */
	public String getScalaAcquisizione() {
		return scalaAcquisizione;
	}

	/**
	 * Sets the scala acquisizione.
	 *
	 * @param scalaAcquisizione the new scala acquisizione
	 */
	public void setScalaAcquisizione(String scalaAcquisizione) {
		this.scalaAcquisizione = scalaAcquisizione;
	}

	/**
	 * Gets the authors.
	 *
	 * @return the authors
	 */
	public List<String> getAuthors() {
		return authors;
	}

	/**
	 * Sets the authors.
	 *
	 * @param authors the new authors
	 */
	public void setAuthors(List<String> authors) {
		this.authors = authors;
	}

	/**
	 * Gets the refers to.
	 *
	 * @return the refers to
	 */
	public BaseConcessioneDV getRefersTo() {
		return refersTo;
	}

	/**
	 * Sets the refers to.
	 *
	 * @param refersTo the new refers to
	 */
	public void setRefersTo(BaseConcessioneDV refersTo) {
		this.refersTo = refersTo;
	}

	/**
	 * To string.
	 *
	 * @return the string
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("LayerConcessioneDV [abstractSection=");
		builder.append(abstractSection);
		builder.append(", topicCategory=");
		builder.append(topicCategory);
		builder.append(", subTopic=");
		builder.append(subTopic);
		builder.append(", bbox=");
		builder.append(bbox);
		builder.append(", valutazioneQualita=");
		builder.append(valutazioneQualita);
		builder.append(", metodoRaccoltaDati=");
		builder.append(metodoRaccoltaDati);
		builder.append(", scalaAcquisizione=");
		builder.append(scalaAcquisizione);
		builder.append(", authors=");
		builder.append(authors);
		builder.append("]");
		return builder.toString();
	}

}
