package org.gcube.application.geoportalcommon.shared.products;

import java.io.Serializable;
import java.util.List;

import org.gcube.application.geoportalcommon.shared.products.model.RecordDV;


/**
 * The Class BaseConcessioneDV.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR francesco.mangiacrapa@isti.cnr.it
 * 
 * Sep 9, 2021
 */
public class BaseConcessioneDV extends RecordDV implements Serializable {


	/**
	 * 
	 */
	private static final long serialVersionUID = -2291409985743665842L;

	/** The introduzione. */
	private String introduzione;

	/** The authors. */
	private List<String> authors;

	/**
	 * Instantiates a new base concessione DV.
	 */
	public BaseConcessioneDV() {
		
	}

	/**
	 * Instantiates a new base concessione DV.
	 *
	 * @param introduzione the introduzione
	 * @param authors the authors
	 */
	public BaseConcessioneDV(String introduzione, List<String> authors) {
		this.introduzione = introduzione;
		this.authors = authors;
	}

	/**
	 * Gets the introduzione.
	 *
	 * @return the introduzione
	 */
	public String getIntroduzione() {
		return introduzione;
	}

	/**
	 * Gets the authors.
	 *
	 * @return the authors
	 */
	public List<String> getAuthors() {
		return authors;
	}

	/**
	 * Sets the introduzione.
	 *
	 * @param introduzione the new introduzione
	 */
	public void setIntroduzione(String introduzione) {
		this.introduzione = introduzione;
	}

	/**
	 * Sets the authors.
	 *
	 * @param authors the new authors
	 */
	public void setAuthors(List<String> authors) {
		this.authors = authors;
	}

}
