package org.gcube.application.geoportalcommon.shared.products.model;

import java.io.Serializable;

import org.gcube.application.geoportalcommon.shared.products.content.AssociatedContentDV;


/**
 * The Class SDILayerDescriptorDV.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR (francesco.mangiacrapa@isti.cnr.it)
 * 
 * Nov 4, 2020
 */
public class SDILayerDescriptorDV extends AssociatedContentDV implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 6137246723753812015L;
	// meta
	private String layerUUID;
	private Long layerID;

	// layer
	private String layerName;
	private String wmsLink;

	/**
	 * Instantiates a new SDI layer descriptor DV.
	 */
	public SDILayerDescriptorDV() {
	}

	/**
	 * Instantiates a new SDI layer descriptor DV.
	 *
	 * @param layerUUID the layer UUID
	 * @param layerID the layer ID
	 * @param layerName the layer name
	 * @param wmsLink the wms link
	 */
	public SDILayerDescriptorDV(String layerUUID, Long layerID, String layerName, String wmsLink) {
		super();
		this.layerUUID = layerUUID;
		this.layerID = layerID;
		this.layerName = layerName;
		this.wmsLink = wmsLink;
	}

	/**
	 * Gets the layer UUID.
	 *
	 * @return the layer UUID
	 */
	public String getLayerUUID() {
		return layerUUID;
	}

	/**
	 * Sets the layer UUID.
	 *
	 * @param layerUUID the new layer UUID
	 */
	public void setLayerUUID(String layerUUID) {
		this.layerUUID = layerUUID;
	}

	/**
	 * Gets the layer ID.
	 *
	 * @return the layer ID
	 */
	public Long getLayerID() {
		return layerID;
	}

	/**
	 * Sets the layer ID.
	 *
	 * @param layerID the new layer ID
	 */
	public void setLayerID(Long layerID) {
		this.layerID = layerID;
	}

	/**
	 * Gets the layer name.
	 *
	 * @return the layer name
	 */
	public String getLayerName() {
		return layerName;
	}

	/**
	 * Sets the layer name.
	 *
	 * @param layerName the new layer name
	 */
	public void setLayerName(String layerName) {
		this.layerName = layerName;
	}

	/**
	 * Gets the wms link.
	 *
	 * @return the wms link
	 */
	public String getWmsLink() {
		return wmsLink;
	}

	/**
	 * Sets the wms link.
	 *
	 * @param wmsLink the new wms link
	 */
	public void setWmsLink(String wmsLink) {
		this.wmsLink = wmsLink;
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.geoportaldataviewer.shared.products.content.AssociatedContentDV#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("SDILayerDescriptor [layerUUID=");
		builder.append(layerUUID);
		builder.append(", layerID=");
		builder.append(layerID);
		builder.append(", layerName=");
		builder.append(layerName);
		builder.append(", wmsLink=");
		builder.append(wmsLink);
		builder.append("]");
		return builder.toString();
	}

}
