package org.gcube.application.geoportalcommon.shared.products.paths;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * The Class FileSetPathsDV.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR francesco.mangiacrapa@isti.cnr.it
 * 
 *         Sep 29, 2021
 */
public class FileSetPathsDV implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 7494678009053802818L;
	List<String> fileSetPaths = new ArrayList<String>();

	/**
	 * Instantiates a new file set paths DV.
	 */
	public FileSetPathsDV() {

	}

	/**
	 * Instantiates a new file set paths DV.
	 *
	 * @param fileSetPaths the file set paths
	 */
	public FileSetPathsDV(List<String> fileSetPaths) {
		super();
		this.fileSetPaths = fileSetPaths;
	}

	/**
	 * Gets the file set paths.
	 *
	 * @return the file set paths
	 */
	public List<String> getFileSetPaths() {
		return fileSetPaths;
	}

	/**
	 * Sets the file set paths.
	 *
	 * @param fileSetPaths the new file set paths
	 */
	public void setFileSetPaths(List<String> fileSetPaths) {
		this.fileSetPaths = fileSetPaths;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("FileSetPathsDV [fileSetPaths=");
		builder.append(fileSetPaths);
		builder.append("]");
		return builder.toString();
	}

}
