package org.gcube.application.geoportalcommon.shared.products.model;

import java.io.Serializable;
import java.util.List;

import org.gcube.application.geoportalcommon.shared.products.content.AssociatedContentDV;
import org.gcube.application.geoportalcommon.shared.products.content.WorkspaceContentDV;


/**
 * The Class RelazioneScavoDV.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR (francesco.mangiacrapa@isti.cnr.it)
 * 
 * Dec 21, 2020
 */
public class RelazioneScavoDV extends AssociatedContentDV implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2456950567302197554L;

	/** The responsabili. */
	private List<String> responsabili;

	/** The soggetto. */
	private List<String> soggetto;
	
	private List<WorkspaceContentDV> listWsContent;

	/**
	 * Instantiates a new relazione scavo DV.
	 */
	public RelazioneScavoDV() {

	}

	/**
	 * Instantiates a new relazione scavo DV.
	 *
	 * @param responsabili the responsabili
	 * @param soggetto the soggetto
	 */
	public RelazioneScavoDV(List<String> responsabili, List<String> soggetto) {
		super();
		this.responsabili = responsabili;
		this.soggetto = soggetto;
	}

	/**
	 * Gets the responsabili.
	 *
	 * @return the responsabili
	 */
	public List<String> getResponsabili() {
		return responsabili;
	}

	/**
	 * Sets the responsabili.
	 *
	 * @param responsabili the new responsabili
	 */
	public void setResponsabili(List<String> responsabili) {
		this.responsabili = responsabili;
	}

	/**
	 * Gets the soggetto.
	 *
	 * @return the soggetto
	 */
	public List<String> getSoggetto() {
		return soggetto;
	}

	/**
	 * Sets the soggetto.
	 *
	 * @param soggetto the new soggetto
	 */
	public void setSoggetto(List<String> soggetto) {
		this.soggetto = soggetto;
	}

	/**
	 * Gets the list ws content.
	 *
	 * @return the list ws content
	 */
	public List<WorkspaceContentDV> getListWsContent() {
		return listWsContent;
	}

	/**
	 * Sets the list ws content.
	 *
	 * @param listWsContent the new list ws content
	 */
	public void setListWsContent(List<WorkspaceContentDV> listWsContent) {
		this.listWsContent = listWsContent;
	}

	/**
	 * To string.
	 *
	 * @return the string
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("RelazioneScavoDV [responsabili=");
		builder.append(responsabili);
		builder.append(", soggetto=");
		builder.append(soggetto);
		builder.append(", listWsContent=");
		builder.append(listWsContent);
		builder.append("]");
		return builder.toString();
	}

	

}
