package org.gcube.application.geoportalcommon.shared;

import java.io.Serializable;
import java.util.List;

import org.gcube.application.geoportalcommon.shared.config.RoleRights;

/**
 * The Class GNADataEntryConfigProfile.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR francesco.mangiacrapa@isti.cnr.it
 * 
 *         Dec 21, 2021
 */
public class GNADataEntryConfigProfile implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 5152380669677928785L;
	private List<ItemField> listItemFields;
	private List<RoleRights> permissionsForRole;

	/**
	 * Instantiates a new GNA data entry config profile.
	 */
	public GNADataEntryConfigProfile() {

	}

	/**
	 * Instantiates a new GNA data entry config profile.
	 *
	 * @param listItemFields     the list item fields
	 * @param permissionsForRole the permissions for role
	 */
	public GNADataEntryConfigProfile(List<ItemField> listItemFields, List<RoleRights> permissionsForRole) {
		super();
		this.listItemFields = listItemFields;
		this.permissionsForRole = permissionsForRole;
	}

	/**
	 * Gets the list item fields.
	 *
	 * @return the list item fields
	 */
	public List<ItemField> getListItemFields() {
		return listItemFields;
	}

	/**
	 * Sets the list item fields.
	 *
	 * @param listItemFields the new list item fields
	 */
	public void setListItemFields(List<ItemField> listItemFields) {
		this.listItemFields = listItemFields;
	}

	/**
	 * Gets the permissions for role.
	 *
	 * @return the permissions for role
	 */
	public List<RoleRights> getPermissionsForRole() {
		return permissionsForRole;
	}

	/**
	 * Sets the permissions for role.
	 *
	 * @param permissionsForRole the new permissions for role
	 */
	public void setPermissionsForRole(List<RoleRights> permissionsForRole) {
		this.permissionsForRole = permissionsForRole;
	}

	/**
	 * To string.
	 *
	 * @return the string
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("GNADataEntryConfigProfile [listItemFields=");
		builder.append(listItemFields);
		builder.append("]");
		return builder.toString();
	}

}
