package org.gcube.application.geoportalcommon.shared;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * The Class GNADataViewerConfigProfile.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR francesco.mangiacrapa@isti.cnr.it
 * 
 *         Dec 21, 2021
 */
public class GNADataViewerConfigProfile implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2968334957258327191L;
	private String restrictedPortletURL;
	private String openPortletURL;
	// the key is the layer type
	private Map<String, LayerItem> mapLayers;
	private List<ItemField> listItemFields;

	/**
	 * Instantiates a new geo na data viewer profile.
	 */
	public GNADataViewerConfigProfile() {

	}

	/**
	 * Gets the restricted portlet URL.
	 *
	 * @return the restricted portlet URL
	 */
	public String getRestrictedPortletURL() {
		return restrictedPortletURL;
	}

	/**
	 * Sets the restricted portlet URL.
	 *
	 * @param restrictedPortletURL the new restricted portlet URL
	 */
	public void setRestrictedPortletURL(String restrictedPortletURL) {
		this.restrictedPortletURL = restrictedPortletURL;
	}

	/**
	 * Gets the open portlet URL.
	 *
	 * @return the open portlet URL
	 */
	public String getOpenPortletURL() {
		return openPortletURL;
	}

	/**
	 * Sets the open portlet URL.
	 *
	 * @param openPortletURL the new open portlet URL
	 */
	public void setOpenPortletURL(String openPortletURL) {
		this.openPortletURL = openPortletURL;
	}

	/**
	 * Gets the map layers.
	 *
	 * @return the map layers
	 */
	public Map<String, LayerItem> getMapLayers() {
		return mapLayers;
	}

	/**
	 * Sets the map layers.
	 *
	 * @param mapLayers the map layers
	 */
	public void setMapLayers(Map<String, LayerItem> mapLayers) {
		this.mapLayers = mapLayers;
	}

	/**
	 * Gets the list item fields.
	 *
	 * @return the list item fields
	 */
	public List<ItemField> getListItemFields() {
		return listItemFields;
	}

	/**
	 * Sets the list item fields.
	 *
	 * @param listItemFields the new list item fields
	 */
	public void setListItemFields(List<ItemField> listItemFields) {
		this.listItemFields = listItemFields;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("GNADataViewerConfigProfile [restrictedPortletURL=");
		builder.append(restrictedPortletURL);
		builder.append(", openPortletURL=");
		builder.append(openPortletURL);
		builder.append(", mapLayers=");
		builder.append(mapLayers);
		builder.append(", listItemFields=");
		builder.append(listItemFields);
		builder.append("]");
		return builder.toString();
	}

}
