package org.gcube.application.geoportal.managers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.gcube.application.geoportal.model.InputStreamDescriptor;
import org.gcube.application.geoportal.model.concessioni.Concessione;
import org.gcube.application.geoportal.model.concessioni.LayerConcessione;
import org.gcube.application.geoportal.model.concessioni.RelazioneScavo;
import org.gcube.application.geoportal.model.content.UploadedImage;
import org.gcube.application.geoportal.model.db.DBConstants;
import org.gcube.application.geoportal.storage.ContentHandler;
import org.gcube.application.geoportal.utils.Serialization;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ConcessioneManager extends AbstractRecordManager<Concessione> {

	protected ConcessioneManager(Concessione theRecord) {
		super(theRecord);
	}


	public Concessione setRelazioneScavo(RelazioneScavo rel, InputStreamDescriptor theFile) throws IOException {
		ContentHandler handler=getContentHandler();
		//Check if already stored content
		Concessione record=getRecord();
		if(record.getRelazioneScavo()!=null && !record.getRelazioneScavo().getActualContent().isEmpty()) {
			handler.dispose(record.getRelazioneScavo());
		}

		rel.setRecord(record);
		
		//Register relazione
		record.setRelazioneScavo(rel);
		handler.register(rel, theFile);

		return record;
	}

	public Concessione addImmagineRappresentativa(UploadedImage img, InputStreamDescriptor theFile) throws IOException {
		ContentHandler handler=getContentHandler();
		Concessione record=getRecord();
		//Add immagine
		
		img.setRecord(record);
		record.getImmaginiRappresentative().add(img);
		handler.register(img, theFile);

		return record;
	}

	//	public Concessione disposeImmagineRappresentativa(UploadedImage img, InputStream theFile) {
	//		if(concessione.)
	//	}

	public Concessione setPosizionamento(LayerConcessione layer, InputStreamDescriptor...inputStreams ) throws IOException {
		ContentHandler handler=getContentHandler();
		//Check if already stored content
		Concessione record=getRecord();
		if(record.getPosizionamentoScavo()!=null && !record.getPosizionamentoScavo().getActualContent().isEmpty())
			handler.dispose(record.getPosizionamentoScavo());

		layer.setRecord(record);
		
		//Register posizionamneot
		record.setPosizionamentoScavo(layer);
		handler.register(layer, inputStreams);

		return record;
	}

	public Concessione addPiantaFineScavo(LayerConcessione layer, InputStreamDescriptor...inputStreams ) throws IOException {
		ContentHandler handler=getContentHandler();
		Concessione record=getRecord();
		//Add pianta
		layer.setRecord(record);
		
		
		record.getPianteFineScavo().add(layer);
		handler.register(layer, inputStreams);

		return record;
	}




//	@Override
//	protected Concessione storeInfo(Concessione toInsert) {
//		log.debug("Storing Record "+toInsert);
//		EntityManager em=getEMF().createEntityManager();
//		try {
//			em.getTransaction().begin();
//			RelazioneScavo relScavo=toInsert.getRelazioneScavo();
//			toInsert.setRelazioneScavo(null);
//			List<UploadedImage> uploadedImages=toInsert.getImmaginiRappresentative();
//			toInsert.setImmaginiRappresentative(null);
//			LayerConcessione posizionamentoScavo=toInsert.getPosizionamentoScavo();
//			toInsert.setPosizionamentoScavo(null);
//			List<LayerConcessione> pianteFineScavo= toInsert.getPianteFineScavo();
//			toInsert.setPianteFineScavo(null);
//			List<OtherContent> genericContent=toInsert.getGenericContent();
//			toInsert.setGenericContent(null);
//			
//			log.debug("Storing empty concessione..  "+toInsert);
//			em.persist(toInsert);
//			
//			if(relScavo!=null) {
//			log.debug("Atttaching relazione .. "+relScavo);
//			relScavo.setRecord(toInsert);
//			toInsert.setRelazioneScavo(relScavo);
//			}
//			
//			if(uploadedImages!=null) {
//				log.debug("Attaching images.. "+uploadedImages);
//				for(UploadedImage image: uploadedImages) 
//					image.setRecord(toInsert);
//				toInsert.setImmaginiRappresentative(uploadedImages);
//			}
//			
//			if(posizionamentoScavo!=null) {
//				toInsert.get
//			}
//				
//			
//			em.getTransaction().commit();
//		}finally {
//			em.close();
//		}		
//	}

	

	@Override
	protected Map<String,String> evaluateCentroid(){

		Concessione record=getRecord();

		// CENTROID 
		Map<String,String> centroidsRow=new HashMap<String, String>();
		centroidsRow.put(DBConstants.Concessioni.ID, record.getId()+"");
		centroidsRow.put(DBConstants.Concessioni.ANNO, record.getDataInizioProgetto().getYear()+"");
		centroidsRow.put(DBConstants.Concessioni.NOME, record.getNome());
		centroidsRow.put(DBConstants.Concessioni.REGIONE, "");
		centroidsRow.put(DBConstants.Defaults.XCOORD_FIELD, record.getCentroidLong()+"");
		centroidsRow.put(DBConstants.Defaults.YCOORD_FIELD, record.getCentroidLat()+"");

		//Updated Schema 
		centroidsRow.put(DBConstants.Concessioni.DESCRIZIONE,record.getIntroduzione());
		centroidsRow.put(DBConstants.Concessioni.CONTENUTO,record.getDescrizioneContenuto());
		centroidsRow.put(DBConstants.Concessioni.AUTORE,Serialization.asString(record.getAuthors()));
		centroidsRow.put(DBConstants.Concessioni.CONTRIBUTORE,record.getContributore());
		centroidsRow.put(DBConstants.Concessioni.TITOLARE,Serialization.asString(record.getTitolari()));
		centroidsRow.put(DBConstants.Concessioni.RESPONSABILE,record.getResponsabile());
		centroidsRow.put(DBConstants.Concessioni.EDITORE,record.getEditore());
		centroidsRow.put(DBConstants.Concessioni.FINANZIAMENTO,Serialization.asString(record.getFontiFinanziamento()));
		centroidsRow.put(DBConstants.Concessioni.SOGGETTO,Serialization.asString(record.getSoggetto()));
		centroidsRow.put(DBConstants.Concessioni.RISORSE,Serialization.asString(record.getRisorseCorrelate()));
		centroidsRow.put(DBConstants.Concessioni.DATE_SCAVO,Serialization.FULL_FORMATTER.format(record.getDataFineProgetto()));
		centroidsRow.put(DBConstants.Concessioni.DATA_ARCHIVIAZIONE,Serialization.FULL_FORMATTER.format(record.getLastUpdateTime()));
		centroidsRow.put(DBConstants.Concessioni.VERSIONE,record.getVersion());
		centroidsRow.put(DBConstants.Concessioni.LICENZA,record.getLicenzaID());
		centroidsRow.put(DBConstants.Concessioni.TITOLARE_LICENZA,record.getTitolareLicenza());
		centroidsRow.put(DBConstants.Concessioni.ACCESSO,record.getAccesso().toString());
		centroidsRow.put(DBConstants.Concessioni.PAROLE_CHIAVE,Serialization.asString(record.getParoleChiaveLibere()));

		return centroidsRow;
	}
}
