package org.gcube.application.geoportal.model;

import java.time.LocalDateTime;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;

import org.gcube.application.geoportal.model.report.ValidationReport;
import org.gcube.application.geoportal.model.vre.GCubeUser;
import org.gcube.application.geoportal.model.vre.SocialManager;
import org.gcube.application.geoportal.utils.Serialization;

import com.fasterxml.jackson.core.JsonProcessingException;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
@Entity
@Inheritance(strategy = InheritanceType.JOINED)
@EqualsAndHashCode
public abstract class Record {

	
	//Generic Info
	@Id @GeneratedValue(strategy=GenerationType.IDENTITY)
	private long id;	
	
	@Enumerated(EnumType.STRING)
	private RecordType recordType;
	private String version="1.0.0";
	private String licenzaID;
	
	@Enumerated(EnumType.STRING)
	private AccessPolicy accesso;
	//Nome del progetto	
	private String nome;
	
	
	//Storage Info
	private String folderId;
	
	//Accounting
	private LocalDateTime lastUpdateTime=LocalDateTime.now();
	private String lastUpdateUser;
	private LocalDateTime creationTime=LocalDateTime.now();
	private String creationUser;
	
	protected Record() {
		GCubeUser user=SocialManager.getCurrentUser();
		
		this.setLastUpdateUser(user.getName());
		this.setCreationUser(user.getName());
		
	}
	
	public String asJson() throws JsonProcessingException {
		return Serialization.asJSON(this);
	}
	
	public ValidationReport validate() {
		ValidationReport validator=new ValidationReport("Core metadata");
		validator.checkMandatory(getRecordType(), "Record Type");
		validator.checkMandatory(getVersion(), "Version");
		validator.checkMandatory(getAccesso(), "Accesso ");
		validator.checkMandatory(getNome(), "Nome");
		validator.checkMandatory(getLastUpdateTime(), "Last Update Time");
		validator.checkMandatory(getLastUpdateUser(), "Last Update User");
		validator.checkMandatory(getCreationTime(), "Creation Time");
		validator.checkMandatory(getCreationUser(), "Creation User");
		validator.checkMandatory(getLicenzaID(), "Licenza ID");
		return validator; 
	}

	
}
