/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.managers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.gcube.application.geoportal.managers.AbstractRecordManager;
import org.gcube.application.geoportal.model.InputStreamDescriptor;
import org.gcube.application.geoportal.model.concessioni.Concessione;
import org.gcube.application.geoportal.model.concessioni.LayerConcessione;
import org.gcube.application.geoportal.model.concessioni.RelazioneScavo;
import org.gcube.application.geoportal.model.content.UploadedImage;
import org.gcube.application.geoportal.storage.ContentHandler;
import org.gcube.application.geoportal.utils.Serialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcessioneManager
extends AbstractRecordManager<Concessione> {
    private static final Logger log = LoggerFactory.getLogger(ConcessioneManager.class);

    protected ConcessioneManager(Concessione theRecord) {
        super(theRecord);
    }

    public Concessione setRelazioneScavo(RelazioneScavo rel, InputStreamDescriptor theFile) throws IOException {
        ContentHandler handler = this.getContentHandler();
        Concessione record = (Concessione)this.getRecord();
        if (record.getRelazioneScavo() != null && !record.getRelazioneScavo().getActualContent().isEmpty()) {
            handler.dispose(record.getRelazioneScavo());
        }
        rel.setRecord(record);
        record.setRelazioneScavo(rel);
        handler.register(rel, theFile);
        return record;
    }

    public Concessione addImmagineRappresentativa(UploadedImage img, InputStreamDescriptor theFile) throws IOException {
        ContentHandler handler = this.getContentHandler();
        Concessione record = (Concessione)this.getRecord();
        img.setRecord(record);
        record.getImmaginiRappresentative().add(img);
        handler.register(img, theFile);
        return record;
    }

    public Concessione setPosizionamento(LayerConcessione layer, InputStreamDescriptor ... inputStreams) throws IOException {
        ContentHandler handler = this.getContentHandler();
        Concessione record = (Concessione)this.getRecord();
        if (record.getPosizionamentoScavo() != null && !record.getPosizionamentoScavo().getActualContent().isEmpty()) {
            handler.dispose(record.getPosizionamentoScavo());
        }
        layer.setRecord(record);
        record.setPosizionamentoScavo(layer);
        handler.register(layer, inputStreams);
        return record;
    }

    public Concessione addPiantaFineScavo(LayerConcessione layer, InputStreamDescriptor ... inputStreams) throws IOException {
        ContentHandler handler = this.getContentHandler();
        Concessione record = (Concessione)this.getRecord();
        layer.setRecord(record);
        record.getPianteFineScavo().add(layer);
        handler.register(layer, inputStreams);
        return record;
    }

    @Override
    protected Map<String, String> evaluateCentroid() {
        Concessione record = (Concessione)this.getRecord();
        HashMap<String, String> centroidsRow = new HashMap<String, String>();
        centroidsRow.put("id", record.getId() + "");
        centroidsRow.put("anno", record.getDataInizioProgetto().getYear() + "");
        centroidsRow.put("nome", record.getNome());
        centroidsRow.put("regione", "");
        centroidsRow.put("xcoord", record.getCentroidLong() + "");
        centroidsRow.put("ycoord", record.getCentroidLat() + "");
        centroidsRow.put("descrizione", record.getIntroduzione());
        centroidsRow.put("contenuto", record.getDescrizioneContenuto());
        centroidsRow.put("autore", Serialization.asString(record.getAuthors()));
        centroidsRow.put("contributore", record.getContributore());
        centroidsRow.put("titolare", Serialization.asString(record.getTitolari()));
        centroidsRow.put("responsabile", record.getResponsabile());
        centroidsRow.put("editore", record.getEditore());
        centroidsRow.put("finanziamento", Serialization.asString(record.getFontiFinanziamento()));
        centroidsRow.put("soggetto", Serialization.asString(record.getSoggetto()));
        centroidsRow.put("risorse", Serialization.asString(record.getRisorseCorrelate()));
        centroidsRow.put("date_scavo", Serialization.FULL_FORMATTER.format(record.getDataFineProgetto()));
        centroidsRow.put("data_archiviazione", Serialization.FULL_FORMATTER.format(record.getLastUpdateTime()));
        centroidsRow.put("versione", record.getVersion());
        centroidsRow.put("licenza", record.getLicenzaID());
        centroidsRow.put("titolare_licenza", record.getTitolareLicenza());
        centroidsRow.put("accesso", record.getPolicy().toString());
        centroidsRow.put("parole_chiave", Serialization.asString(record.getParoleChiaveLibere()));
        return centroidsRow;
    }
}

