/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.model.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.application.geoportal.model.report.Check;

public class ConstraintCheck<T> {
    private T theObject;
    private String fieldLabel;
    private String message;
    private boolean error = false;
    private boolean mandatory;
    private T theDefault;
    private List<Check> additionalChecks = new ArrayList<Check>();

    public static <T> ConstraintCheck<T> defaultFor(T toCheck, T defaultValue) {
        return new ConstraintCheck<T>(toCheck, new Check[0]).withDefault(defaultValue);
    }

    public ConstraintCheck(T theObject, Check ... checks) {
        this.theObject = theObject;
        for (Check c : checks) {
            this.additionalChecks.add(c);
        }
        this.check();
    }

    public ConstraintCheck<T> withDefault(T theDefault) {
        this.theDefault = theDefault;
        return this;
    }

    public ConstraintCheck<T> addChecks(Check ... checks) {
        for (Check c : checks) {
            this.additionalChecks.add(c);
        }
        return this;
    }

    public ConstraintCheck(T theObject, String fieldLabel, Check ... checks) {
        this.theObject = theObject;
        this.fieldLabel = fieldLabel;
        for (Check c : checks) {
            this.additionalChecks.add(c);
        }
        this.check();
    }

    public T evaluate() {
        this.check();
        Object result = this.theObject;
        if (this.isError()) {
            result = this.theDefault;
            if (this.theDefault != null && this.theDefault instanceof Collection) {
                Collection defaultCollection = (Collection)this.theDefault;
                ArrayList target = new ArrayList(defaultCollection);
                result = target;
            }
        }
        return result;
    }

    private void check() {
        if (this.theObject == null) {
            this.setMessage(this.fieldLabel + " \u00e8 un campo obbligatorio.");
            this.setError(true);
        } else if (this.theObject instanceof String && ((String)this.theObject).isEmpty()) {
            this.setMessage(this.fieldLabel + " non pu\u00f2 essere vuoto.");
            this.setError(true);
        } else if (this.theObject instanceof Collection) {
            Collection toCheckCollection = (Collection)this.theObject;
            if (toCheckCollection.isEmpty()) {
                this.setMessage("La lista " + this.fieldLabel + " non pu\u00f2 essere vuota.");
                this.setError(true);
            }
            Boolean containsError = false;
            Object[] array = toCheckCollection.toArray(new Object[toCheckCollection.size()]);
            for (int i = 0; i < array.length; ++i) {
                containsError = new ConstraintCheck<Object>(array[i], this.fieldLabel + " [elemento N\u00b0 " + i + "]", new Check[0]).isError();
            }
            this.setError(containsError);
        } else {
            for (Check check : this.additionalChecks) {
                if (check.isOk(this.theObject)) continue;
                this.setError(true);
                this.setMessage(check.getMessage());
            }
        }
    }

    public T getTheObject() {
        return this.theObject;
    }

    public String getFieldLabel() {
        return this.fieldLabel;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public T getTheDefault() {
        return this.theDefault;
    }

    public List<Check> getAdditionalChecks() {
        return this.additionalChecks;
    }

    public void setTheObject(T theObject) {
        this.theObject = theObject;
    }

    public void setFieldLabel(String fieldLabel) {
        this.fieldLabel = fieldLabel;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public void setTheDefault(T theDefault) {
        this.theDefault = theDefault;
    }

    public void setAdditionalChecks(List<Check> additionalChecks) {
        this.additionalChecks = additionalChecks;
    }
}

