/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.utils;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.gcube.application.geoportal.model.db.PostgisTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSV {
    private static final Logger log = LoggerFactory.getLogger(CSV.class);

    public static final CSVParser fromPath(String csvFile) throws FileNotFoundException, IOException {
        return CSVParser.parse((Reader)new FileReader(csvFile), (CSVFormat)CSVFormat.DEFAULT.withFirstRecordAsHeader());
    }

    public static PostgisTable.GeometryType getTypeFromPath(String csv) {
        PostgisTable.GeometryType type = PostgisTable.GeometryType.POINT;
        if (csv.contains("linee")) {
            type = PostgisTable.GeometryType.LINE;
        } else if (csv.contains("poligoni")) {
            type = PostgisTable.GeometryType.POLYGON;
        }
        return type;
    }
}

