/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.application.geoportal.model.fault.DataParsingException;
import org.gcube.application.geoportal.model.gis.BBOX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUtils {
    private static final Logger log = LoggerFactory.getLogger(DBUtils.class);
    private static Pattern pattern = Pattern.compile("(?!=\\d\\.\\d\\.)([\\d.]+)");

    public static BBOX parseST_Extent(String extent) throws DataParsingException {
        try {
            log.debug("Parsing BBOX " + extent);
            Matcher m = pattern.matcher(extent);
            if (!m.find()) {
                throw new DataParsingException("Unable to get minLong ");
            }
            Double minLong = Double.parseDouble(m.group(1));
            if (!m.find()) {
                throw new DataParsingException("Unable to get minLat ");
            }
            Double minLat = Double.parseDouble(m.group(1));
            if (!m.find()) {
                throw new DataParsingException("Unable to get maxLong ");
            }
            Double maxLong = Double.parseDouble(m.group(1));
            if (!m.find()) {
                throw new DataParsingException("Unable to get maxLat ");
            }
            Double maxLat = Double.parseDouble(m.group(1));
            return new BBOX(maxLat, maxLong, minLat, minLong);
        }
        catch (Throwable t) {
            throw new DataParsingException("Invalid BBOX " + extent, t);
        }
    }
}

