/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.managers;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import org.gcube.application.geoportal.managers.DefatulEMFProvider;
import org.gcube.application.geoportal.managers.EMFProvider;
import org.gcube.application.geoportal.model.Record;
import org.gcube.application.geoportal.model.db.PostgisTable;
import org.gcube.application.geoportal.model.fault.ConfigurationException;
import org.gcube.application.geoportal.model.fault.PersistenceException;
import org.gcube.application.geoportal.model.fault.PublishException;
import org.gcube.application.geoportal.model.fault.SDIInteractionException;
import org.gcube.application.geoportal.model.fault.ValidationException;
import org.gcube.application.geoportal.model.report.PublicationReport;
import org.gcube.application.geoportal.model.report.ValidationReport;
import org.gcube.application.geoportal.storage.ContentHandler;
import org.gcube.application.geoportal.storage.PostgisDBManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecordManager<T extends Record> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRecordManager.class);
    private static final Object $LOCK = new Object[0];
    private static EMFProvider defaultProvider = new DefatulEMFProvider();
    EntityTransaction transaction = null;
    EntityManager entityManager = AbstractRecordManager.getEMF().createEntityManager();
    private T theRecord;
    private ContentHandler<T> contentHandler;

    public static void setDefaultProvider(EMFProvider provider) {
        defaultProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static EntityManagerFactory getEMF() {
        Object object = $LOCK;
        synchronized (object) {
            return defaultProvider.getFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Object object = $LOCK;
        synchronized (object) {
            defaultProvider.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Record getByID(long id) {
        EntityManager em = AbstractRecordManager.getEMF().createEntityManager();
        try {
            log.debug("Looking for record by ID : " + id);
            EntityTransaction tr = em.getTransaction();
            Record toReturn = (Record)em.find(Record.class, (Object)id);
            log.debug("Loaded Record " + toReturn);
            Record record = toReturn;
            return record;
        }
        finally {
            if (em.isJoinedToTransaction()) {
                em.flush();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Record> getList() {
        EntityManager em = AbstractRecordManager.getEMF().createEntityManager();
        try {
            log.debug("Getting entire list");
            EntityTransaction tr = em.getTransaction();
            tr.begin();
            List toReturn = em.createQuery("select r from Record r ", Record.class).getResultList();
            log.debug("Loaded size " + toReturn.size());
            tr.commit();
            List list = toReturn;
            return list;
        }
        finally {
            if (em.isJoinedToTransaction()) {
                em.flush();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Record> Collection<E> getListByClass(Class<E> clazz) {
        EntityManager em = AbstractRecordManager.getEMF().createEntityManager();
        try {
            log.debug("Getting entire list");
            EntityTransaction tr = em.getTransaction();
            tr.begin();
            String simpleClassName = clazz.getName().substring(clazz.getName().lastIndexOf(".") + 1);
            List toReturn = em.createQuery("select r from " + simpleClassName + " r", clazz).getResultList();
            log.debug("Loaded size " + toReturn.size());
            tr.commit();
            List list = toReturn;
            return list;
        }
        finally {
            if (em.isJoinedToTransaction()) {
                em.flush();
            }
            em.close();
        }
    }

    protected AbstractRecordManager(T theRecord) {
        this.transaction = this.entityManager.getTransaction();
        this.transaction.begin();
        this.theRecord = theRecord;
        if (((Record)theRecord).getId() == 0L) {
            log.debug("Passed record ID = 0. Assuming new ..");
            this.entityManager.persist(theRecord);
        } else {
            log.debug("Passed record ID = " + ((Record)theRecord).getId() + ". Mergeing..");
            this.theRecord = (Record)this.entityManager.find(theRecord.getClass(), (Object)((Record)theRecord).getId());
        }
        this.contentHandler = new ContentHandler<T>(theRecord);
    }

    protected ContentHandler<T> getContentHandler() {
        return this.contentHandler;
    }

    public T getRecord() {
        return this.theRecord;
    }

    public T commit(boolean publish) throws PersistenceException, ValidationException, PublishException {
        log.trace("Committing record " + this.theRecord + " Publish is " + publish);
        try {
            ValidationReport report = ((Record)this.theRecord).validate();
            log.debug("Validated Report is " + report);
            log.debug("Record is valid, storing changed content");
            this.contentHandler.storeChanges();
            this.commit();
            this.transaction.begin();
            if (publish) {
                if (report.getStatus().equals((Object)ValidationReport.ValidationStatus.ERROR)) {
                    throw new ValidationException(report, "Cannot publish project. See validation report");
                }
                log.debug("Publishing record " + this.theRecord);
                this.contentHandler.publish();
                this.commit();
                this.transaction.begin();
                log.debug("Registering centroid of " + this.theRecord);
                this.registerCentroid();
                this.commit();
            }
            return this.theRecord;
        }
        catch (PersistenceException | PublishException | ValidationException e) {
            log.warn("Committing session for " + this.theRecord);
            if (this.transaction.isActive()) {
                this.transaction.rollback();
            }
            throw e;
        }
    }

    private void commit() {
        log.debug("Successufully committing " + this.theRecord);
        this.entityManager.flush();
        this.entityManager.clear();
        this.transaction.commit();
        log.debug("Calling postCommit");
        this.postcommit();
    }

    protected abstract void postcommit();

    public PublicationReport commitSafely(boolean publish) {
        PublicationReport toReturn;
        block8: {
            log.debug("Safely publishing " + this.theRecord);
            toReturn = new PublicationReport("Publication Report");
            toReturn.setTheRecord((Record)this.getRecord());
            ValidationReport validation = ((Record)this.theRecord).validate();
            this.commit();
            this.transaction.begin();
            validation.setObjectName("Validation report for " + validation.getObjectName());
            if (validation.getStatus().equals((Object)ValidationReport.ValidationStatus.ERROR)) {
                toReturn.addMessage(publish ? ValidationReport.ValidationStatus.ERROR : ValidationReport.ValidationStatus.WARNING, "Record not valid.");
            }
            toReturn.addChild(validation);
            try {
                log.debug("Storing changed content [Publish is :" + publish + "]");
                toReturn.addChild(this.contentHandler.storeChanges());
                this.commit();
                this.transaction.begin();
                if (publish) {
                    toReturn.addChild(this.contentHandler.publish());
                    this.commit();
                    log.debug("Registering centroid of " + this.theRecord);
                    this.registerCentroid();
                    toReturn.addMessage(ValidationReport.ValidationStatus.PASSED, "Inserito centroide per record " + ((Record)this.theRecord).getId());
                }
                log.debug("Committing session for " + this.theRecord);
                this.commit();
            }
            catch (PersistenceException e) {
                toReturn.addChild(e.getReport());
                log.warn("Unexpected internal exception ", (Throwable)e);
                log.debug("Rollback Session for " + this.theRecord);
                if (this.transaction.isActive()) {
                    this.transaction.rollback();
                }
            }
            catch (PublishException e) {
                toReturn.addMessage(ValidationReport.ValidationStatus.WARNING, "Centroide non registrato");
                log.warn("Unexpected internal exception ", (Throwable)e);
                log.debug("Committing session for " + this.theRecord);
                if (!this.transaction.isActive()) break block8;
                this.commit();
            }
        }
        try {
            log.info("Report is " + toReturn.prettyPrint());
        }
        catch (Exception e) {
            log.warn("Unable to pretty print report " + toReturn, (Throwable)e);
        }
        return toReturn;
    }

    public void publish() {
        block2: {
            PublicationReport toReturn = new PublicationReport("Publication Report");
            toReturn.setTheRecord((Record)this.getRecord());
            this.transaction.begin();
            try {
                toReturn.addChild(this.contentHandler.publish());
                this.commit();
                this.transaction.begin();
                log.debug("Registering centroid of " + this.theRecord);
                this.registerCentroid();
                toReturn.addMessage(ValidationReport.ValidationStatus.PASSED, "Inserito centroide per record " + ((Record)this.theRecord).getId());
                log.debug("Committing session for " + this.theRecord);
                this.commit();
            }
            catch (PublishException e) {
                toReturn.addMessage(ValidationReport.ValidationStatus.WARNING, "Centroide non registrato");
                log.warn("Unexpected internal exception ", (Throwable)e);
                log.debug("Committing session for " + this.theRecord);
                if (!this.transaction.isActive()) break block2;
                this.commit();
            }
        }
    }

    public void delete() {
        this.onDelete();
        this.removeCentroid();
        this.transaction.commit();
    }

    protected abstract void onDelete();

    public void close() {
        try {
            if (this.transaction.isActive()) {
                this.transaction.rollback();
            }
        }
        catch (Throwable t) {
            log.warn("Exception while closing ", t);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private void removeCentroid() {
        try {
            PostgisDBManager db = PostgisDBManager.get();
            PostgisTable centroidsTable = this.getCentroidsTable();
            log.debug("Deleting centroid if present. ID is " + ((Record)this.theRecord).getId());
            db.deleteByFieldValue(centroidsTable, new PostgisTable.Field("product_id", PostgisTable.FieldType.TEXT), ((Record)this.theRecord).getId() + "");
        }
        catch (Exception e) {
            log.warn("Unable to remove centroid ", (Throwable)e);
        }
    }

    private void registerCentroid() throws PublishException {
        try {
            log.debug("Evaluating Centroid");
            Map<String, String> centroidRow = this.evaluateCentroid();
            log.debug("Contacting postgis DB .. ");
            PostgisDBManager db = PostgisDBManager.get();
            PostgisTable centroidsTable = this.getCentroidsTable();
            log.debug("Inserting / updated centroid Row {} ", centroidRow);
            PreparedStatement ps = db.prepareInsertStatement(centroidsTable, true, true);
            log.debug("Deleting centroid if present. ID is " + ((Record)this.theRecord).getId());
            db.deleteByFieldValue(centroidsTable, new PostgisTable.Field("product_id", PostgisTable.FieldType.TEXT), ((Record)this.theRecord).getId() + "");
            centroidsTable.fillCSVPreparedStatament(centroidRow, ps, false);
            ps.executeUpdate();
            db.commit();
            this.initCentroidLayer();
        }
        catch (SQLException e) {
            log.warn("Unable to publish Centroid for record " + this.theRecord, (Throwable)e);
            throw new PublishException("Unable to publish centroid.", e, null);
        }
        catch (SDIInteractionException e) {
            log.warn("Unable to publish Centroid Layer for record type " + (Object)((Object)((Record)this.getRecord()).getRecordType()), (Throwable)e);
            throw new PublishException("Unable to publish centroid.", e, null);
        }
        catch (ConfigurationException e) {
            log.warn("Unable to contact centroids db " + (Object)((Object)((Record)this.getRecord()).getRecordType()), (Throwable)e);
            throw new PublishException("Unable to publish centroid.", e, null);
        }
    }

    protected abstract PostgisTable getCentroidsTable();

    protected abstract void initCentroidLayer() throws SDIInteractionException;

    protected abstract Map<String, String> evaluateCentroid();
}

