/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.model.concessioni;

import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import org.gcube.application.geoportal.model.content.AssociatedContent;
import org.gcube.application.geoportal.model.report.Check;
import org.gcube.application.geoportal.model.report.ValidationReport;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.Type;

@Entity
@DiscriminatorValue(value="RELAZIONE")
public class RelazioneScavo
extends AssociatedContent {
    @Type(type="text")
    private String abstractSection;
    @Type(type="text")
    private String abstractIta;
    @Type(type="text")
    private String abstractEng;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection(targetClass=String.class)
    private List<String> responsabili;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection(targetClass=String.class)
    private List<String> soggetto;

    @Override
    public ValidationReport validateForInsertion() {
        ValidationReport toReturn = super.validateForInsertion();
        toReturn.setObjectName("Relazione Scavo");
        toReturn.checkMandatory(this.responsabili, "Responsabili", new Check[0]);
        toReturn.checkMandatory(this.soggetto, "Soggetto", new Check[0]);
        return toReturn;
    }

    public String getAbstractSection() {
        return this.abstractSection;
    }

    public String getAbstractIta() {
        return this.abstractIta;
    }

    public String getAbstractEng() {
        return this.abstractEng;
    }

    public List<String> getResponsabili() {
        return this.responsabili;
    }

    public List<String> getSoggetto() {
        return this.soggetto;
    }

    public void setAbstractSection(String abstractSection) {
        this.abstractSection = abstractSection;
    }

    public void setAbstractIta(String abstractIta) {
        this.abstractIta = abstractIta;
    }

    public void setAbstractEng(String abstractEng) {
        this.abstractEng = abstractEng;
    }

    public void setResponsabili(List<String> responsabili) {
        this.responsabili = responsabili;
    }

    public void setSoggetto(List<String> soggetto) {
        this.soggetto = soggetto;
    }

    @Override
    public String toString() {
        return "RelazioneScavo(super=" + super.toString() + ", abstractSection=" + this.getAbstractSection() + ", abstractIta=" + this.getAbstractIta() + ", abstractEng=" + this.getAbstractEng() + ", responsabili=" + this.getResponsabili() + ", soggetto=" + this.getSoggetto() + ")";
    }
}

