/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.features.user.FeatureResultSet;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.gcube.application.geoportal.PostgisTableFactory;
import org.gcube.application.geoportal.model.Configuration;
import org.gcube.application.geoportal.model.db.DBConstants;
import org.gcube.application.geoportal.model.db.PostgisTable;
import org.gcube.application.geoportal.model.fault.ConfigurationException;
import org.gcube.application.geoportal.model.fault.InvalidRecordException;
import org.gcube.application.geoportal.storage.PostgisDBManager;
import org.gcube.application.geoportal.utils.GpkgUtils;
import org.gcube.spatial.data.geonetwork.GeoNetworkPublisher;
import org.gcube.spatial.data.gis.GISInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Uploader {
    private static final Logger log = LoggerFactory.getLogger(Uploader.class);
    private GISInterface gis;
    private GeoNetworkPublisher geonetwork;
    private Configuration config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertConcessioni(File CSVFile, Boolean centroidsOnly) throws FileNotFoundException, IOException, SQLException, ConfigurationException {
        log.info("Connecting to postgresDB.. ");
        log.info("Parsing file " + CSVFile.getAbsolutePath());
        File exportedFolder = new File(CSVFile.getParent() + File.separator + "esportazioni");
        try (CSVParser parser = null;){
            parser = CSVParser.parse((Reader)new FileReader(CSVFile), (CSVFormat)CSVFormat.DEFAULT.withFirstRecordAsHeader());
            Map headerMap = parser.getHeaderMap();
            log.debug("Headers are : " + (headerMap == null ? null : headerMap.keySet()));
            PostgisDBManager db = PostgisDBManager.get();
            PostgisTableFactory tableFactory = new PostgisTableFactory(db);
            PostgisTable centroids = DBConstants.Concessioni.CENTROIDS;
            if (this.config.getUseTestSuffixes().booleanValue()) {
                centroids.setTablename(centroids.getTablename() + "_test");
            }
            PreparedStatement psCentroids = db.prepareInsertStatement(centroids, true, true);
            if (this.config.getCleanUpBeforeUpdate().booleanValue()) {
                log.info("Cleaning up Centroids.. " + centroids);
                db.truncate(centroids.getTablename());
            }
            for (CSVRecord r : parser.getRecords()) {
                String nomeConcessione = r.get("nome");
                try {
                    log.info("Importing " + nomeConcessione + " [" + r.getRecordNumber() + "] ");
                    if (!centroidsOnly.booleanValue() && Boolean.parseBoolean(r.get("csv"))) {
                        String[] csvNames;
                        for (String csv : csvNames = r.get("nome_csv").split(",")) {
                            String csvPath = exportedFolder.getAbsolutePath() + File.separator + csv + ".csv";
                            log.debug("loading CSV : " + csvPath);
                            PostgisTable table = tableFactory.fromCSV(csvPath);
                            log.debug("Committing table..");
                            db.commit();
                            String layerName = nomeConcessione + " " + csv;
                            log.debug("Creating layer " + layerName);
                        }
                    }
                    HashMap<String, String> centroidsRow = new HashMap<String, String>();
                    centroidsRow.put("anno", r.get("anno"));
                    centroidsRow.put("nome", r.get("nome"));
                    centroidsRow.put("regione", r.get("regione"));
                    centroidsRow.put("xcoord", r.get("xcentroid"));
                    centroidsRow.put("ycoord", r.get("ycentroid"));
                    centroidsRow.put("descrizione", r.get("descrizione_progetto"));
                    centroidsRow.put("contenuto", r.get("descrizione_contenuto"));
                    centroidsRow.put("autore", r.get("autore"));
                    centroidsRow.put("contributore", r.get("contributore"));
                    centroidsRow.put("titolare", r.get("titolare_dati"));
                    centroidsRow.put("responsabile", r.get("responsabile"));
                    centroidsRow.put("editore", r.get("editore"));
                    centroidsRow.put("finanziamento", r.get("finanziamento"));
                    centroidsRow.put("soggetto", r.get("soggetto"));
                    centroidsRow.put("risorse", r.get("risorse_correlate"));
                    centroidsRow.put("date_scavo", r.get("date_scavo"));
                    centroidsRow.put("data_archiviazione", r.get("data_archiviazione"));
                    centroidsRow.put("versione", r.get("versione"));
                    centroidsRow.put("licenza", r.get("licenza"));
                    centroidsRow.put("titolare_licenza", r.get("titolare_licenza_copyright"));
                    centroidsRow.put("accesso", r.get("accesso_dati"));
                    centroidsRow.put("parole_chiave", r.get("parole_chiave"));
                    centroids.fillCSVPreparedStatament(centroidsRow, psCentroids, false);
                    psCentroids.executeUpdate();
                }
                catch (SQLException e) {
                    throw new SQLException("Unable to insert record ", e);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Unexpected error while handling " + r.toMap(), t);
                }
            }
            db.commit();
        }
    }

    public void insertMOSIFromTemplate(String gpkgFile, String requestedTable, Boolean centroidsOnly) throws Exception {
        GeoPackage gpkg = GpkgUtils.open(new File(gpkgFile));
        PostgisDBManager db = PostgisDBManager.get();
        PostgisTableFactory tableFactory = new PostgisTableFactory(db);
        PostgisTable centroids = DBConstants.MOSI.CENTROID_MOSI;
        if (this.config.getUseTestSuffixes().booleanValue()) {
            centroids.setTablename(centroids.getTablename() + "_test");
        }
        PreparedStatement psCentroids = db.prepareInsertStatement(centroids, true, true);
        if (this.config.getCleanUpBeforeUpdate().booleanValue()) {
            db.truncate(centroids.getTablename());
        }
        ArrayList<String> tablenames = new ArrayList<String>();
        if (requestedTable == null) {
            log.debug("Scanning GPKG fro MOSIs");
            for (String s : gpkg.getFeatureTables()) {
                if (!s.startsWith("MOSI")) continue;
                tablenames.add(s);
            }
        } else {
            tablenames.add(requestedTable);
        }
        for (String tablename : tablenames) {
            FeatureDao featureDao = gpkg.getFeatureDao(tablename);
            PostgisTable mosiSchema = tableFactory.fromGPKGFeatureTable(gpkg, tablename, false);
            FeatureResultSet rs = (FeatureResultSet)featureDao.rawQuery("SELECT distinct(accc) from " + tablename);
            log.debug("Found " + rs.getCount() + " codes");
            while (rs.moveToNext()) {
                String code = rs.getString(0);
                PostgisTable siteTable = tableFactory.createAs(mosiSchema, code);
                PreparedStatement psInsert = db.prepareInsertStatement(siteTable, true, false);
                FeatureResultSet rsByCode = (FeatureResultSet)featureDao.query("accc='" + code + "'");
                log.debug("Found " + rsByCode.getCount() + " entries for site " + code);
                int insertedCount = 0;
                while (rsByCode.moveToNext()) {
                    try {
                        Map<String, Object> row = GpkgUtils.rowAsMap(rsByCode, siteTable.getFields());
                        siteTable.fillObjectsPreparedStatement(row, psInsert);
                        insertedCount += psInsert.executeUpdate();
                    }
                    catch (InvalidRecordException e) {
                        log.debug("Skipping Invalid row, cause : ", (Object)e.getMessage());
                    }
                }
                if (insertedCount != 0) {
                    siteTable.setBoundingBox(db.evaluateBoundingBox(siteTable));
                    siteTable.setCentroid(db.evaluateCentroid(siteTable));
                    if (centroidsOnly.booleanValue()) {
                        db.deleteTable(siteTable.getTablename());
                    }
                    HashMap<String, String> centroidsRow = new HashMap<String, String>();
                    centroidsRow.put("code", code);
                    centroidsRow.put("xcoord", siteTable.getCentroid().getX() + "");
                    centroidsRow.put("ycoord", siteTable.getCentroid().getY() + "");
                    centroids.fillCSVPreparedStatament(centroidsRow, psCentroids, false);
                    psCentroids.executeUpdate();
                    continue;
                }
                log.debug("No actual row registered for site : " + code);
                db.deleteTable(siteTable.getTablename());
            }
        }
        db.commit();
    }

    public void cleanUp() {
    }
}

