/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.utils;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.features.user.FeatureResultSet;
import mil.nga.geopackage.manager.GeoPackageManager;
import org.gcube.application.geoportal.model.db.PostgisTable;
import org.gcube.application.geoportal.model.fault.InvalidRecordException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpkgUtils {
    private static final Logger log = LoggerFactory.getLogger(GpkgUtils.class);

    public static GeoPackage open(File gpkg) {
        return GeoPackageManager.open((File)gpkg);
    }

    public static Map<String, Object> rowAsMap(FeatureResultSet rs, List<PostgisTable.Field> targetSchema) throws InvalidRecordException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        block8: for (int i = 0; i < targetSchema.size(); ++i) {
            PostgisTable.Field current = targetSchema.get(i);
            switch (current.getType()) {
                case FLOAT: {
                    row.put(current.getName(), Float.valueOf(rs.getFloat(i)));
                    continue block8;
                }
                case INT: {
                    row.put(current.getName(), rs.getInt(i));
                    continue block8;
                }
                case TEXT: {
                    row.put(current.getName(), rs.getString(i));
                    continue block8;
                }
                case GEOMETRY: {
                    try {
                        row.put(current.getName(), rs.getGeometry().getWkbBytes());
                        continue block8;
                    }
                    catch (Throwable t) {
                        throw new InvalidRecordException("Unable to read Geom ", t);
                    }
                }
            }
        }
        return row;
    }
}

