package org.gcube.application.geoportal.service.engine.providers;

import lombok.extern.slf4j.Slf4j;
import org.gcube.application.geoportal.service.ServiceConstants;
import org.gcube.application.geoportal.service.engine.ImplementationProvider;
import org.gcube.application.geoportal.service.model.internal.db.Mongo;
import org.gcube.application.geoportal.service.model.internal.db.MongoConnection;
import org.gcube.application.geoportal.service.model.internal.faults.ConfigurationException;

@Slf4j
public class MongoClientProvider extends AbstractScopedMap<Mongo>{

	public MongoClientProvider() {
		super("MongoClient cache");
		//NO TTL = Map by context
//		setTTL(Duration.of(10, ChronoUnit.MINUTES));
	}

	@Override
	protected Mongo retrieveObject() throws ConfigurationException {
		MongoConnection conn=ImplementationProvider.get().
				getIsProvider().getIS().queryForMongoDB(
						ServiceConstants.MONGO_SE_PLATFORM, ServiceConstants.MONGO_SE_GNA_FLAG);

		log.debug("Connecting to "+conn);
		 return new Mongo(conn);
	}
	
	@Override
	protected void dispose(Mongo toDispose) {
		toDispose.close();
	}
	
	@Override
	public void init() {
		// TODO Auto-generated method stub
	}
}
