/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.mongo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingQueue;
import javax.ws.rs.WebApplicationException;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.gcube.application.cms.serialization.Serialization;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.rest.QueryRequest;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.UseCaseDescriptor;
import org.gcube.application.geoportal.common.utils.ContextUtils;
import org.gcube.application.geoportal.service.engine.mongo.MongoManager;
import org.gcube.application.geoportal.service.engine.mongo.UCDManagerI;
import org.gcube.application.geoportal.service.model.internal.faults.RegistrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UCDMongoManager
extends MongoManager
implements UCDManagerI {
    private static final Logger log = LoggerFactory.getLogger(UCDMongoManager.class);

    public UCDMongoManager() throws ConfigurationException {
        this.init("UCD_" + ContextUtils.getCurrentScope().replaceAll("/", "_"));
    }

    public long deleteAll() {
        return this.getCollection().deleteMany((Bson)new Document()).getDeletedCount();
    }

    protected String mongoIDFieldName() {
        return "_mongoId";
    }

    public UseCaseDescriptor insert(UseCaseDescriptor desc) throws RegistrationException {
        try {
            if (desc.getMongoId() != null) {
                throw new RegistrationException("UCD has already a mongo ID");
            }
            ObjectId id = this.insertDoc(Serialization.asDocument((Object)desc));
            desc.setMongoId(id);
            return (UseCaseDescriptor)Serialization.convert((Object)this.getDocById(id), UseCaseDescriptor.class);
        }
        catch (JsonProcessingException e) {
            log.error("Unexpected serialization exception ", (Throwable)e);
            throw new WebApplicationException("Unexpected exception ", (Throwable)e);
        }
    }

    public UseCaseDescriptor put(UseCaseDescriptor desc) throws RegistrationException, ConfigurationException {
        log.debug("PUT UCD ID {} MONGO ID {}", (Object)desc.getId(), (Object)desc.getMongoId());
        Document filter = new Document("_id", (Object)desc.getId());
        if (desc.getMongoId() != null) {
            filter.put("_mongoId", (Object)desc.getMongoId());
        }
        try {
            UseCaseDescriptor toReturn = (UseCaseDescriptor)Serialization.convert((Object)this.getCollection().findOneAndReplace((Bson)filter, (Object)Serialization.asDocument((Object)desc), new FindOneAndReplaceOptions().returnDocument(ReturnDocument.AFTER)), UseCaseDescriptor.class);
            if (toReturn == null) {
                if (desc.getMongoId() != null) {
                    throw new RegistrationException("Illegal attempt to write to " + desc.getId() + " with unmatching mongo ID ");
                }
                log.debug("Unable to update UCD {}. Inserting it..", (Object)desc.getId());
                toReturn = this.insert(desc);
            }
            log.info("Updated UCD in DB cache. ID {}, MONGO ID {}", (Object)toReturn.getId(), (Object)toReturn.getMongoId());
            log.trace("Updated UCD is {} ", (Object)toReturn);
            return toReturn;
        }
        catch (RegistrationException e) {
            throw e;
        }
        catch (Throwable e) {
            log.error("Unable to update ", e);
            throw new RegistrationException("Invalid UCD provided " + e.getMessage());
        }
    }

    public Iterable<UseCaseDescriptor> query(QueryRequest queryRequest) {
        log.info("Searching UCD for {} ", (Object)queryRequest);
        LinkedBlockingQueue<UseCaseDescriptor> queue = new LinkedBlockingQueue<UseCaseDescriptor>();
        FindIterable it = this.queryDoc(queryRequest);
        it.forEach(d -> {
            try {
                queue.put((UseCaseDescriptor)Serialization.convert((Object)d, UseCaseDescriptor.class));
            }
            catch (Throwable t) {
                log.warn("Unable to translate " + d, t);
            }
        });
        log.info("Returned {} elements ", (Object)queue.size());
        return queue;
    }

    public void deleteById(String id, boolean force) throws ConfigurationException {
        this.deleteDoc(this.getById(id).getMongoId());
    }

    public UseCaseDescriptor getById(String id) throws ConfigurationException {
        log.info("Getting UC by ID {} ", (Object)id);
        QueryRequest request = new QueryRequest();
        request.setFilter(new Document("_id", (Object)id));
        try {
            return (UseCaseDescriptor)this.query(request).iterator().next();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

