/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.gcube.application.geoportal.service.utils.UserUtils;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.ClientInfo;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserUtils {
    private static final Logger log = LoggerFactory.getLogger(UserUtils.class);
    public static List<String> DEFAULT_ROLES = new ArrayList();

    public static AuthenticatedUser getCurrent() throws SecurityException {
        String context = ScopeProvider.instance.get();
        if (context == null) {
            throw new SecurityException("Cannot determine context");
        }
        log.debug("Context is {}, checking tokens..", (Object)context);
        ClientInfo client = null;
        HashSet roles = new HashSet();
        try {
            client = AuthorizationProvider.instance.get().getClient();
            roles = new HashSet(client.getRoles());
        }
        catch (Throwable e) {
            log.warn("Unable to get client info ", e);
            roles = new HashSet();
        }
        AuthenticatedUser toReturn = new AuthenticatedUser(client, roles, AccessTokenProvider.instance.get(), SecurityTokenProvider.instance.get(), context);
        log.info("Current User is {} ", (Object)toReturn);
        return toReturn;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

