/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.providers.ucd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.gcube.application.cms.caches.AbstractScopedMap;
import org.gcube.application.cms.caches.ObjectManager;
import org.gcube.application.cms.implementations.ISInterface;
import org.gcube.application.cms.implementations.ImplementationProvider;
import org.gcube.application.cms.serialization.Serialization;
import org.gcube.application.geoportal.common.model.document.filesets.RegisteredFile;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.UseCaseDescriptor;
import org.gcube.application.geoportal.service.engine.WorkspaceManager;
import org.gcube.application.geoportal.service.engine.providers.ucd.ProfileMap;
import org.gcube.application.geoportal.service.engine.providers.ucd.SingleISResourceUCDProvider;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SingleISResourceUCDProvider
extends AbstractScopedMap<ProfileMap>
implements ObjectManager<UseCaseDescriptor> {
    private static final Logger log = LoggerFactory.getLogger(SingleISResourceUCDProvider.class);
    private static final String GR_SECONDARY_TYPE = "CMS";
    private static final String GR_NAME = "UCDs";
    private static JAXBContext jaxbContext = null;
    private static Marshaller marshaller = null;
    private static Unmarshaller unmarshaller = null;

    public SingleISResourceUCDProvider() {
        super("Single IS Resource UCD Provider");
        this.setTTL((TemporalAmount)Duration.of(1L, ChronoUnit.MICROS));
    }

    public UseCaseDescriptor insert(UseCaseDescriptor object) throws ConfigurationException {
        try {
            log.info("Registering UCID {}", (Object)object.getId());
            log.debug("Full UCD {} ", (Object)object);
            WorkspaceManager manager = new WorkspaceManager();
            WorkspaceManager.FolderOptions fo = new WorkspaceManager.FolderOptions();
            fo.setFolderName("UCDs");
            fo.setParent(manager.getAppBase());
            fo.setFolderDescription("UCDs registered from server");
            FolderContainer folder = manager.createFolder(fo);
            String jsonString = Serialization.write((Object)object);
            WorkspaceManager.FileOptions fileOptions = new WorkspaceManager.FileOptions((InputStream)new ByteArrayInputStream(jsonString.getBytes(StandardCharsets.UTF_8)));
            fileOptions.setFileName(object.getId());
            fileOptions.setFileDescription(object.getName() + ", ID : " + object.getId());
            fileOptions.setParent(folder);
            RegisteredFile f = manager.registerFile(fileOptions);
            log.info("Registered File {}", (Object)f);
            ISInterface is = (ISInterface)ImplementationProvider.get().getProvidedObjectByClass(ISInterface.class);
            List l = is.getGenericResource("CMS", "UCDs");
            log.debug("Found {} resources ", (Object)l.size());
            GenericResource toupdate = null;
            ISBean bean = new ISBean();
            try {
                toupdate = (GenericResource)l.get(0);
                log.debug("GR IS {}", (Object)toupdate);
                bean = SingleISResourceUCDProvider.read((String)toupdate.profile().bodyAsString());
            }
            catch (Throwable t) {
                log.warn("Unable to read from selected GR, creating it..", t);
                toupdate = new GenericResource();
                toupdate.newProfile().name("UCDs").type("CMS").description("Generated by service at " + LocalDateTime.now());
            }
            if (bean.getRecords() == null) {
                bean.setRecords(new ArrayList());
            }
            ISBean.Record record = new ISBean.Record();
            record.setUcdUrl(f.getLink());
            record.setLabel(object.getName());
            bean.getRecords().add(record);
            log.debug("Inserting record {} ", (Object)record);
            String xml = SingleISResourceUCDProvider.write((ISBean)bean).replaceFirst("<\\?.*\\?>", "");
            toupdate.profile().newBody(xml);
            log.info("Creating / Updating GR {} ", (Object)toupdate);
            is.createUpdateGR(toupdate);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ConfigurationException(e);
        }
        return object;
    }

    public void init() {
        super.init();
        try {
            SingleISResourceUCDProvider.directInit();
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to initialize. Can't read Use case descriptors ", t);
        }
    }

    static void directInit() throws JAXBException {
        jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ISBean.class});
        marshaller = jaxbContext.createMarshaller();
        unmarshaller = jaxbContext.createUnmarshaller();
    }

    static ISBean read(String xml) throws JAXBException {
        log.trace("Loading from xml {}", (Object)xml);
        if (xml == null || xml.isEmpty()) {
            return new ISBean();
        }
        return (ISBean)unmarshaller.unmarshal((Reader)new StringReader(xml));
    }

    static String write(ISBean obj) throws JAXBException {
        log.trace("Writing {} to xml", (Object)obj);
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)obj, (Writer)writer);
        writer.flush();
        return writer.toString();
    }

    protected ProfileMap retrieveObject(String key) throws ConfigurationException {
        try {
            log.info("Loading UCDs for context {} ", (Object)key);
            ISInterface is = (ISInterface)ImplementationProvider.get().getProvidedObjectByClass(ISInterface.class);
            List l = is.getGenericResource("CMS", "UCDs");
            log.debug("Found {} resources ", (Object)l.size());
            ProfileMap toReturn = new ProfileMap();
            l.forEach(g -> {
                try {
                    log.debug("Reading from ID {} ", (Object)g.id());
                    ISBean bean = SingleISResourceUCDProvider.read((String)g.profile().bodyAsString());
                    log.debug("Found {} records ", (Object)bean.getRecords().size());
                    int before = toReturn.size();
                    bean.getRecords().forEach(record -> {
                        try {
                            log.debug("Loading UCD From {} ", record);
                            String json = new Scanner(new URL(record.getUcdUrl()).openStream(), "UTF-8").useDelimiter("\\A").next();
                            log.trace("JSON IS {} ", (Object)json);
                            UseCaseDescriptor ucd = (UseCaseDescriptor)Serialization.read((String)json, UseCaseDescriptor.class);
                            if (toReturn.containsKey((Object)ucd.getId())) {
                                log.warn("DUPLICATE UCID found {} in resource {} ", (Object)ucd.getId(), (Object)g.id());
                            }
                            toReturn.put((Object)ucd.getId(), (Object)ucd);
                        }
                        catch (Throwable t) {
                            log.warn("Unable to read record {} from GR ID {} ", new Object[]{record, g.id(), t});
                        }
                    });
                    log.debug("Loaded {} from {} ", (Object)(toReturn.size() - before), (Object)g.id());
                }
                catch (Throwable t) {
                    log.warn("Unable to read from GR {} ", (Object)g.id(), (Object)t);
                }
            });
            return toReturn;
        }
        catch (Throwable t) {
            throw new ConfigurationException("Unable to load UCDs for " + key, t);
        }
    }
}

