/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.providers.ucd;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.application.cms.caches.AbstractScopedMap;
import org.gcube.application.cms.caches.Engine;
import org.gcube.application.cms.caches.ObjectManager;
import org.gcube.application.cms.implementations.ImplementationProvider;
import org.gcube.application.cms.serialization.Serialization;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.rest.QueryRequest;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.UseCaseDescriptor;
import org.gcube.application.geoportal.common.utils.ContextUtils;
import org.gcube.application.geoportal.service.engine.mongo.UCDManagerI;
import org.gcube.application.geoportal.service.engine.mongo.UCDMongoManager;
import org.gcube.application.geoportal.service.engine.providers.ucd.ProfileMap;
import org.gcube.application.geoportal.service.model.internal.faults.RegistrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UCDManager
extends AbstractScopedMap<UCDManagerI>
implements UCDManagerI {
    private static final Logger log = LoggerFactory.getLogger(UCDManager.class);
    private Map<String, UseCaseDescriptor> memCache = new HashMap();
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();

    public UCDManager() {
        super("UCD MANAGER");
        this.setTTL((TemporalAmount)Duration.of(2L, ChronoUnit.MINUTES));
    }

    public Iterable<UseCaseDescriptor> query(QueryRequest queryRequest) throws ConfigurationException {
        this.cacheLock.readLock().lock();
        try {
            Iterable iterable = this.getMongoManager().query(queryRequest);
            return iterable;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    public void deleteById(String id, boolean force) throws RegistrationException, ConfigurationException {
        UseCaseDescriptor found = this.getByUCID(id, true);
        this.cacheLock.writeLock().lock();
        try {
            if (found != null) {
                throw new WebApplicationException("TO IMPLEMENT ", Response.Status.INTERNAL_SERVER_ERROR);
            }
            throw new WebApplicationException("No Matching UCD with ID " + id, Response.Status.NOT_FOUND);
        }
        catch (Throwable throwable) {
            this.cacheLock.writeLock().unlock();
            throw throwable;
        }
    }

    public UseCaseDescriptor put(UseCaseDescriptor desc) throws ConfigurationException, RegistrationException {
        log.info("Update UCD {} ", (Object)desc.getId());
        log.debug("Mongo id is {} ", (Object)desc.getMongoId());
        UseCaseDescriptor found = this.getByUCID(desc.getId(), true);
        if (found != null) {
            throw new WebApplicationException("Update Feature is yet TO IMPLEMENT ", Response.Status.INTERNAL_SERVER_ERROR);
        }
        this.registerNew(desc);
        this.forceUpdateCache();
        int attempt = 0;
        do {
            found = this.getByUCID(desc.getId(), true);
            log.info("Waiting for backend to update.. ");
            try {
                Thread.sleep(4000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        } while (found == null && ++attempt <= 4);
        return found;
    }

    protected UCDManagerI retrieveObject(String context) throws ConfigurationException {
        this.forceUpdateCache();
        return this;
    }

    public UseCaseDescriptor getById(String id) throws ConfigurationException, RegistrationException {
        return this.getByUCID(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UseCaseDescriptor getByUCID(String ucid, boolean refreshOnMissing) throws ConfigurationException {
        log.debug("Trying to getById from memcache {} [refresh on missing : {}]", (Object)ucid, (Object)refreshOnMissing);
        this.cacheLock.readLock().lock();
        boolean releaseLock = true;
        UseCaseDescriptor toReturn = null;
        try {
            if (this.memCache.containsKey(ucid)) {
                toReturn = (UseCaseDescriptor)this.memCache.get(ucid);
            } else if (refreshOnMissing) {
                this.cacheLock.readLock().unlock();
                releaseLock = false;
                this.forceUpdateCache();
                toReturn = this.getByUCID(ucid, false);
            }
        }
        finally {
            if (releaseLock) {
                this.cacheLock.readLock().unlock();
            }
        }
        return toReturn;
    }

    private void registerNew(UseCaseDescriptor ucd) throws ConfigurationException {
        block4: {
            this.cacheLock.writeLock().lock();
            try {
                Engine engine = ImplementationProvider.get().getEngineByManagedClass(ProfileMap.class);
                if (engine instanceof ObjectManager) {
                    ((ObjectManager)engine).insert((Object)ucd);
                    break block4;
                }
                throw new ConfigurationException("Profile Map Engine is not Object Manager. Actual implementation is " + engine.getClass());
            }
            finally {
                this.cacheLock.writeLock().unlock();
            }
        }
    }

    private UCDMongoManager getMongoManager() throws ConfigurationException {
        return new UCDMongoManager();
    }

    private void forceUpdateCache() throws ConfigurationException {
        log.info("UPDATING PROFILE CACHE..");
        this.cacheLock.writeLock().lock();
        UCDMongoManager manager = this.getMongoManager();
        manager.deleteAll();
        this.memCache.clear();
        Engine liveMapProvider = ImplementationProvider.get().getEngineByManagedClass(ProfileMap.class);
        log.trace("LiveMap Provider class is {} ", liveMapProvider.getClass());
        ProfileMap liveMap = (ProfileMap)liveMapProvider.getObject();
        log.debug("LiveMap size is {} ", (Object)liveMap.size());
        for (Map.Entry entry : liveMap.entrySet()) {
            UseCaseDescriptor useCaseDescriptor = (UseCaseDescriptor)Serialization.convert(entry.getValue(), UseCaseDescriptor.class);
            try {
                log.debug("Updateing cache with {}, mongo id is {}", (Object)useCaseDescriptor.getId(), (Object)useCaseDescriptor.getMongoId());
                if (useCaseDescriptor.getMongoId() != null) {
                    log.warn("Retrieved UCD {} from Live Map has a Mongo id [{}]. Removing it..", (Object)useCaseDescriptor.getId(), (Object)useCaseDescriptor.getMongoId());
                    useCaseDescriptor.setMongoId(null);
                }
                manager.insert(useCaseDescriptor);
                this.memCache.put(useCaseDescriptor.getId(), useCaseDescriptor);
            }
            catch (RegistrationException e) {
                log.warn("Unable to cache UCD {}", entry.getKey(), (Object)e);
            }
        }
        log.info("Cached {} UCDs in {} ", (Object)this.memCache.size(), (Object)ContextUtils.getCurrentScope());
        this.cacheLock.writeLock().unlock();
    }
}

