package org.gcube.application.geoportal.service.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.gcube.application.geoportal.common.model.rest.QueryRequest;

import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;

@Slf4j
public class Serialization {

	
	public static final DateTimeFormatter FULL_FORMATTER=DateTimeFormatter.ofPattern("uuuuMMdd_HH-mm-ss");
	
	public static ObjectMapper mapper;
		
		static {
			mapper=new ObjectMapper();
			mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES,false);
			mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
			mapper.registerModule(new JavaTimeModule());

		}
		
		public static <T> T read(String jsonString,Class<T> clazz) throws JsonProcessingException, IOException {
			return mapper.readerFor(clazz).readValue(jsonString);
		}

		public static <T> Iterator<T> readCollection(String jsonString, Class<T> clazz) throws IOException {
			return mapper.readerFor(clazz).readValues(jsonString);
		}


		public static String write(Object toWrite) throws JsonProcessingException {
			String toReturn= mapper.writeValueAsString(toWrite);
			return toReturn;
		}


		public static QueryRequest parseQuery(String queryString) throws IOException {
			log.debug("Parsing query Request {} ",queryString);
			Document queryDocument = Document.parse(queryString);
			log.debug("Document is ",queryDocument.toJson());
			QueryRequest req = new QueryRequest();
			if (queryDocument.getOrDefault("ordering",null)!=null)
				req.setOrdering(Serialization.read(((Document) queryDocument.get("ordering")).toJson(), QueryRequest.OrderedRequest.class));
			if (queryDocument.getOrDefault("paging",null)!=null)
				req.setPaging(Serialization.read(((Document) queryDocument.get("paging")).toJson(), QueryRequest.PagedRequest.class));
			req.setProjection(queryDocument.get("projection", Document.class));
			req.setFilter(queryDocument.get("filter", Document.class));
			return req;
		}

}
