/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.providers;

import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.gcube.application.cms.implementations.ProjectAccess;
import org.gcube.application.cms.implementations.faults.InvalidUserRoleException;
import org.gcube.application.cms.implementations.faults.ProjectNotFoundException;
import org.gcube.application.cms.implementations.faults.RegistrationException;
import org.gcube.application.cms.implementations.faults.UnauthorizedAccess;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.model.document.relationships.Relationship;
import org.gcube.application.geoportal.common.model.document.relationships.RelationshipNavigationObject;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.rest.QueryRequest;
import org.gcube.application.geoportal.service.engine.mongo.ProfiledMongoManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProjectAccessImpl
implements ProjectAccess {
    private static final Logger log = LoggerFactory.getLogger(ProjectAccessImpl.class);

    public Project getById(String ucid, String id) throws RegistrationException, ConfigurationException, InvalidUserRoleException, ProjectNotFoundException, UnauthorizedAccess {
        return new ProfiledMongoManager(ucid).getByID(id);
    }

    public Iterable<Document> query(String ucid, QueryRequest query) throws RegistrationException, ConfigurationException, InvalidUserRoleException {
        return new ProfiledMongoManager(ucid).query(query);
    }

    public List<RelationshipNavigationObject> getRelations(String ucid, String id, String relation, Boolean deep) throws InvalidUserRoleException, RegistrationException, ProjectNotFoundException, ConfigurationException, UnauthorizedAccess {
        return ProjectAccessImpl.getRelationshipChain((String)ucid, (String)id, (String)relation, (Boolean)deep);
    }

    public static List<RelationshipNavigationObject> getRelationshipChain(String ucid, String id, String relationshipId, Boolean deep) throws RegistrationException, ConfigurationException, InvalidUserRoleException, ProjectNotFoundException, UnauthorizedAccess {
        ProfiledMongoManager manager = new ProfiledMongoManager(ucid);
        log.info("UCD {} : Getting Relationships List for {} [rel : {}, recurse {}]", new Object[]{manager.getUseCaseDescriptor().getId(), id, relationshipId, deep});
        Project current = manager.getByID(id);
        long startTime = System.currentTimeMillis();
        List toReturn = ProjectAccessImpl.getLinked((Project)current, (String)relationshipId, (Boolean)deep);
        log.info("Got {} relationship elements in {}ms", (Object)toReturn.size(), (Object)(System.currentTimeMillis() - startTime));
        return toReturn;
    }

    private static List<RelationshipNavigationObject> getLinked(Project current, String relationName, Boolean recurse) {
        log.debug("Getting Relationships Lists for {} [rel : {}, recurse {}]", new Object[]{current.getId(), relationName, recurse});
        ArrayList<RelationshipNavigationObject> toReturn = new ArrayList<RelationshipNavigationObject>();
        List existing = current.getRelationshipsByName(relationName);
        for (Relationship relationship : existing) {
            try {
                log.trace("Navigating from  {} : {} to[rel {} ] {} : {}", new Object[]{relationship.getTargetUCD(), relationship.getTargetID(), relationship.getRelationshipName(), current.getProfileID(), current.getId()});
                RelationshipNavigationObject linkedProject = new RelationshipNavigationObject();
                linkedProject.setTarget(new ProfiledMongoManager(relationship.getTargetUCD()).getByID(relationship.getTargetID()));
                if (recurse.booleanValue()) {
                    linkedProject.setChildren(ProjectAccessImpl.getLinked((Project)linkedProject.getTarget(), (String)relationName, (Boolean)recurse));
                }
                toReturn.add(linkedProject);
            }
            catch (Exception e) {
                log.warn("Unable to navigate from  {} : {} to[rel {} ] {} : {}", new Object[]{relationship.getTargetUCD(), relationship.getTargetID(), relationship.getRelationshipName(), current.getProfileID(), current.getId(), e});
            }
        }
        return toReturn;
    }
}

