/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.rest;

import com.webcohesion.enunciate.metadata.Ignore;
import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.bson.Document;
import org.gcube.application.cms.plugins.events.EventManager;
import org.gcube.application.geoportal.common.model.configuration.Configuration;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.model.document.access.Access;
import org.gcube.application.geoportal.common.model.document.lifecycle.LifecycleInformation;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.rest.PerformStepRequest;
import org.gcube.application.geoportal.common.model.rest.RegisterFileSetRequest;
import org.gcube.application.geoportal.service.accounting.CalledMethodHandler;
import org.gcube.application.geoportal.service.engine.mongo.ProfiledMongoManager;
import org.gcube.application.geoportal.service.http.PATCH;
import org.gcube.application.geoportal.service.rest.ProfiledDocuments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="projects/{usecase_id}")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
public class ProfiledDocuments {
    private static final Logger log = LoggerFactory.getLogger(ProfiledDocuments.class);
    public static final String HIDDEN_PATH = "hidden";
    private ProfiledMongoManager manager;
    private EventManager eventManager = EventManager.getInstance();

    public ProfiledDocuments(@PathParam(value="usecase_id") String profileID) throws ConfigurationException {
        log.info("Accessing profile " + profileID);
        this.manager = (ProfiledMongoManager)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @GET
    @Path(value="configuration")
    @Produces(value={"application/json"})
    public Configuration getConfiguration(@PathParam(value="usecase_id") String profileID) {
        String path = CalledMethodHandler.buildCalledResource((String)"GET", (String)("/projects/" + profileID));
        CalledMethodHandler.setCalledMethod((String)(path + "/" + "configuration"));
        return (Configuration)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Project createNew(Document d) {
        String path = CalledMethodHandler.buildCalledResource((String)"POST", (String)("/projects/" + this.manager.getUseCaseDescriptor().getId()));
        CalledMethodHandler.setCalledMethod((String)(path + "/createNew"));
        Project theNewProject = (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
        LifecycleInformation.Status status = theNewProject.getLifecycleInformation().getLastOperationStatus();
        if (status != null && !status.equals((Object)LifecycleInformation.Status.ERROR)) {
            4 autThr = null;
            try {
                autThr = new /* Unavailable Anonymous Inner Class!! */;
                autThr.start();
            }
            catch (Exception e) {
                log.warn("Error occurred when notifying event " + EventManager.Event.PROJECT_CREATED, (Throwable)e);
            }
            finally {
                if (autThr != null) {
                    autThr.resetContext();
                }
            }
        }
        return theNewProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{project_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Project update(@PathParam(value="project_id") String documentId, Document d) {
        String path = CalledMethodHandler.buildCalledResource((String)"PUT", (String)("/projects/" + this.manager.getUseCaseDescriptor().getId()));
        CalledMethodHandler.setCalledMethod((String)(path + "/{" + "project_id" + "}"));
        Project theUpdatedProject = (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
        LifecycleInformation.Status status = theUpdatedProject.getLifecycleInformation().getLastOperationStatus();
        if (status != null && !status.equals((Object)LifecycleInformation.Status.ERROR)) {
            6 autThr = null;
            try {
                autThr = new /* Unavailable Anonymous Inner Class!! */;
                autThr.start();
            }
            catch (Exception e) {
                log.warn("Error occurred when notifying event " + EventManager.Event.PROJECT_UPDATED, (Throwable)e);
            }
            finally {
                if (autThr != null) {
                    autThr.resetContext();
                }
            }
        }
        return theUpdatedProject;
    }

    @PATCH
    @Path(value="{project_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Project patch(@PathParam(value="project_id") String documentId, Document d) {
        String path = CalledMethodHandler.buildCalledResource((String)"PATCH", (String)("/projects/" + this.manager.getUseCaseDescriptor().getId()));
        CalledMethodHandler.setCalledMethod((String)(path + "/{" + "project_id" + "}"));
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="{project_id}")
    public Boolean delete(@PathParam(value="project_id") String id, @DefaultValue(value="false") @QueryParam(value="force") Boolean force) {
        return this.delete(id, force, Boolean.valueOf(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Produces(value={"application/json"})
    @Path(value="{project_id}/hidden")
    @Ignore
    public Boolean delete(@PathParam(value="project_id") String id, @DefaultValue(value="false") @QueryParam(value="force") Boolean force, @QueryParam(value="ignore_errors") Boolean ignoreErrors) {
        String path = CalledMethodHandler.buildCalledResource((String)"DELETE", (String)("/projects/" + this.manager.getUseCaseDescriptor().getId()));
        CalledMethodHandler.setCalledMethod((String)(path + "/{" + "project_id" + "}"));
        Boolean deleted = (Boolean)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
        if (deleted.booleanValue()) {
            9 autThr = null;
            try {
                autThr = new /* Unavailable Anonymous Inner Class!! */;
                autThr.start();
            }
            catch (Exception e) {
                log.warn("Error occurred when notifying event " + EventManager.Event.PROJECT_DELETED, (Throwable)e);
            }
            finally {
                if (autThr != null) {
                    autThr.resetContext();
                }
            }
        }
        return deleted;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/registerFiles/{project_id}")
    public Project registerFileSet(@PathParam(value="project_id") String id, RegisterFileSetRequest request) {
        String path = CalledMethodHandler.buildCalledResource((String)"POST", (String)("/projects/" + this.manager.getUseCaseDescriptor().getId()));
        CalledMethodHandler.setCalledMethod((String)(path + "/" + "registerFiles" + "/{" + "project_id" + "}"));
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @RequestHeaders(value={@RequestHeader(name="Authorization", description="VRE Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/deleteFiles/{project_id}")
    public Project deleteFileSet(@PathParam(value="project_id") String id, @DefaultValue(value="false") @QueryParam(value="force") Boolean force, String path) {
        return this.deleteFileSet(id, force, Boolean.valueOf(false), path);
    }

    @RequestHeaders(value={@RequestHeader(name="Authorization", description="VRE Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/deleteFiles/hidden/{project_id}")
    @Ignore
    public Project deleteFileSet(@PathParam(value="project_id") String id, @DefaultValue(value="false") @QueryParam(value="force") Boolean force, @DefaultValue(value="false") @QueryParam(value="ignore_errors") Boolean ignore_errors, String path) {
        String pathCalledResource = CalledMethodHandler.buildCalledResource((String)"POST", (String)("/projects/" + this.manager.getUseCaseDescriptor().getId()));
        CalledMethodHandler.setCalledMethod((String)(pathCalledResource + "/" + "deleteFiles" + "/{" + "project_id" + "}"));
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/step/{project_id}")
    public Project performStep(@PathParam(value="project_id") String id, PerformStepRequest performStepRequest) {
        String pathCalledResource = CalledMethodHandler.buildCalledResource((String)"POST", (String)("/projects/" + this.manager.getUseCaseDescriptor().getId()));
        CalledMethodHandler.setCalledMethod((String)(pathCalledResource + "/" + "step" + "/{" + "project_id" + "}"));
        Project theProject = (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
        LifecycleInformation.Status status = theProject.getLifecycleInformation().getLastOperationStatus();
        if (status != null && !status.equals((Object)LifecycleInformation.Status.ERROR)) {
            13 autThr = null;
            try {
                autThr = new /* Unavailable Anonymous Inner Class!! */;
                autThr.start();
            }
            catch (Exception e) {
                log.warn("Error occurred when notifying event " + EventManager.Event.LIFECYCLE_STEP_PERFORMED, (Throwable)e);
            }
            finally {
                if (autThr != null) {
                    autThr.resetContext();
                }
            }
        }
        return theProject;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/forceUnlock/{project_id}")
    public Project forceUnlock(@PathParam(value="project_id") String id) {
        String pathCalledResource = CalledMethodHandler.buildCalledResource((String)"PUT", (String)("/projects/" + this.manager.getUseCaseDescriptor().getId()));
        CalledMethodHandler.setCalledMethod((String)(pathCalledResource + "/" + "forceUnlock" + "/{" + "project_id" + "}"));
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/setAccess/{project_id}")
    public Project setAccessPolicy(@PathParam(value="project_id") String id, Access toSet) {
        String pathCalledResource = CalledMethodHandler.buildCalledResource((String)"PUT", (String)("/projects/" + this.manager.getUseCaseDescriptor().getId()));
        CalledMethodHandler.setCalledMethod((String)(pathCalledResource + "/" + "setAccess" + "/{" + "project_id" + "}"));
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @GET
    @Produces(value={"application/json"})
    public Iterable<?> list() {
        String pathCalledResource = CalledMethodHandler.buildCalledResource((String)"GET", (String)("/projects/" + this.manager.getUseCaseDescriptor().getId()));
        CalledMethodHandler.setCalledMethod((String)pathCalledResource);
        return (Iterable)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{project_id}")
    public Project getById(@PathParam(value="project_id") String id) {
        String pathCalledResource = CalledMethodHandler.buildCalledResource((String)"GET", (String)("/projects/" + this.manager.getUseCaseDescriptor().getId()));
        CalledMethodHandler.setCalledMethod((String)(pathCalledResource + "/{" + "project_id" + "}"));
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/search")
    public String search(String filter) {
        String pathCalledResource = CalledMethodHandler.buildCalledResource((String)"POST", (String)("/projects/" + this.manager.getUseCaseDescriptor().getId()));
        CalledMethodHandler.setCalledMethod((String)(pathCalledResource + "/" + "search"));
        return (String)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/query")
    public Iterable<?> query(String queryString) {
        String pathCalledResource = CalledMethodHandler.buildCalledResource((String)"POST", (String)("/projects/" + this.manager.getUseCaseDescriptor().getId()));
        CalledMethodHandler.setCalledMethod((String)(pathCalledResource + "/" + "query"));
        return (Iterable)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{relationship}/{project_id}/{relationship_id}")
    public String getRelationshipChain(@PathParam(value="project_id") String id, @PathParam(value="relationship_id") String relationshipId, @DefaultValue(value="false") @QueryParam(value="deep") Boolean deep) {
        String pathCalledResource = CalledMethodHandler.buildCalledResource((String)"GET", (String)("/projects/" + this.manager.getUseCaseDescriptor().getId()));
        CalledMethodHandler.setCalledMethod((String)(pathCalledResource + "/{" + "relationship" + "}/{" + "project_id" + "}/{" + "relationship_id" + "}"));
        return (String)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="{relationship}/{project_id}/{relationship_id}")
    public Project setRelation(@PathParam(value="project_id") String id, @PathParam(value="relationship_id") String relationshipId, @QueryParam(value="target_id") String targetId, @QueryParam(value="target_ucd") String targetUCD) {
        String pathCalledResource = CalledMethodHandler.buildCalledResource((String)"PUT", (String)("/projects/" + this.manager.getUseCaseDescriptor().getId()));
        CalledMethodHandler.setCalledMethod((String)(pathCalledResource + "/{" + "relationship" + "}/{" + "project_id" + "}/{" + "relationship_id" + "}"));
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="{relationship}/{project_id}/{relationship_id}")
    public Project deleteRelation(@PathParam(value="project_id") String id, @PathParam(value="relationship_id") String relationshipId, @QueryParam(value="target_id") String targetId, @QueryParam(value="target_ucd") String targetUCD) {
        String pathCalledResource = CalledMethodHandler.buildCalledResource((String)"DELETE", (String)("/projects/" + this.manager.getUseCaseDescriptor().getId()));
        CalledMethodHandler.setCalledMethod((String)(pathCalledResource + "/{" + "relationship" + "}/{" + "project_id" + "}/{" + "relationship_id" + "}"));
        return (Project)new /* Unavailable Anonymous Inner Class!! */.execute().getResult();
    }

    static /* synthetic */ ProfiledMongoManager access$000(ProfiledDocuments x0) {
        return x0.manager;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static /* synthetic */ EventManager access$200(ProfiledDocuments x0) {
        return x0.eventManager;
    }
}

