/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.images;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.gcube.application.aquamaps.images.Common;
import org.gcube.application.aquamaps.images.exceptions.ImageNotFoundException;
import org.gcube.application.aquamaps.images.exceptions.InvalidRequestException;
import org.gcube.common.core.utils.logging.GCUBELog;

public class Pics
extends HttpServlet {
    private static final GCUBELog logger = new GCUBELog(Pics.class);
    private static Common common = Common.get();
    private static final long serialVersionUID = 6192206746569409892L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        InputStream is = null;
        try {
            String scientificName = req.getParameter("species");
            if (scientificName == null) {
                throw new InvalidRequestException();
            }
            scientificName = scientificName.toLowerCase();
            resp.setContentType("image/jpeg");
            is = common.getSpeciesPicture(scientificName);
            IOUtils.copy((InputStream)is, (OutputStream)resp.getOutputStream());
        }
        catch (IOException e) {
            is = common.getImageNotFound();
            IOUtils.copy((InputStream)is, (OutputStream)resp.getOutputStream());
        }
        catch (ImageNotFoundException e) {
            is = common.getImageNotFound();
            IOUtils.copy((InputStream)is, (OutputStream)resp.getOutputStream());
        }
        catch (InvalidRequestException e) {
            resp.setStatus(400);
        }
        catch (Exception e) {
            logger.error((Object)"Unexpected error ", (Throwable)e);
            resp.setStatus(500);
        }
        finally {
            if (is != null) {
                IOUtils.closeQuietly((InputStream)is);
            }
            try {
                IOUtils.closeQuietly((OutputStream)resp.getOutputStream());
            }
            catch (Throwable t) {
                logger.error((Object)"", t);
            }
        }
    }
}

