/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.images;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.JdbcPooledConnectionSource;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gcube.application.aquamaps.aquamapsservice.client.plugins.AbstractPlugin;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.Maps;
import org.gcube.application.aquamaps.images.Common;
import org.gcube.application.aquamaps.images.SpeciesInfoImportThread;
import org.gcube.application.aquamaps.images.exceptions.ImageNotFoundException;
import org.gcube.application.aquamaps.images.model.MapItem;
import org.gcube.application.aquamaps.images.model.ProductType;
import org.gcube.application.aquamaps.images.model.SpeciesInfo;
import org.gcube.application.aquamaps.images.model.Statistics;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.GeoNetworkReader;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Common {
    public static final String IMAGE_JPEG = "image/jpeg";
    private static final String IMAGE_BASE_URL = "http://www.fishbase.org/images/thumbnails/jpg/";
    private static final Logger logger = LoggerFactory.getLogger(Common.class);
    private static final String configFile = "config.properties";
    public static final String SCOPE_PROP = "SCOPE";
    public static final String SUITABLE_PROP = "SUITABLE_ID";
    public static final String SUITABLE_2050_PROP = "SUITABLE_2050_ID";
    public static final String NATIVE_PROP = "NATIVE_ID";
    public static final String NATIVE_2050_PROP = "NATIVE_2050_ID";
    public static final String HELP_FILE = "HELP_FILE";
    public static final String IMAGE_NOT_FOUND_FILE = "IMAGE_NOT_FOUND_FILE";
    public static final String FETCH_ROUTINE_INTERVAL_MINUTES = "FETCH_ROUTINE_INTERVAL_MINUTES";
    private static Common instance;
    private Properties props = new Properties();
    private Statistics statistics = new Statistics();
    private Dao<MapItem, Integer> mapDao;
    private Dao<SpeciesInfo, String> speciesDao;
    private Long lastCompletedUpdate = 0L;
    private Map<String, String> lastConfiguration = null;
    private GeoNetworkReader gnReader = null;

    public static synchronized Common get() {
        if (instance == null) {
            instance = new Common();
        }
        return instance;
    }

    private Common() {
        try {
            1 t = new /* Unavailable Anonymous Inner Class!! */;
            t.start();
            JdbcPooledConnectionSource connectionSource = new JdbcPooledConnectionSource("jdbc:h2:mem:occurrence;DB_CLOSE_DELAY=-1");
            this.mapDao = DaoManager.createDao((ConnectionSource)connectionSource, MapItem.class);
            this.speciesDao = DaoManager.createDao((ConnectionSource)connectionSource, SpeciesInfo.class);
            TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, SpeciesInfo.class);
            TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, MapItem.class);
            SpeciesInfoImportThread.start((Properties)this.props);
        }
        catch (SQLException e) {
            logger.error("Unable to create db", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Unexpected error", (Throwable)e);
        }
    }

    public Maps getAMInterface() throws Exception {
        ScopeProvider.instance.set(this.props.getProperty(SCOPE_PROP));
        return (Maps)AbstractPlugin.maps().build();
    }

    private synchronized GeoNetworkReader getGeoNetworkReader() throws Exception {
        if (this.gnReader == null) {
            ScopeProvider.instance.set(this.props.getProperty(SCOPE_PROP));
            this.gnReader = GeoNetwork.get();
            this.gnReader.login(LoginLevel.DEFAULT);
        }
        return this.gnReader;
    }

    public MapItem getMap(Integer hspecId, String scientificName) throws SQLException, ImageNotFoundException {
        QueryBuilder queryBuilder = this.mapDao.queryBuilder();
        List found = this.mapDao.query(queryBuilder.where().eq("hspecId", (Object)hspecId).and().eq("scientificName", (Object)scientificName).prepare());
        if (found.size() == 0) {
            throw new ImageNotFoundException();
        }
        return (MapItem)found.get(0);
    }

    public List<MapItem> getMapsBySpecies(String scientificName) throws SQLException {
        QueryBuilder queryBuilder = this.mapDao.queryBuilder();
        return this.mapDao.query(queryBuilder.where().eq("scientificName", (Object)scientificName).prepare());
    }

    public SpeciesInfo getSpeciesInfo(String scientificName) throws SQLException {
        QueryBuilder queryBuilder = this.speciesDao.queryBuilder();
        queryBuilder.where().eq("scientificName", (Object)scientificName);
        return (SpeciesInfo)this.speciesDao.queryForFirst(queryBuilder.prepare());
    }

    public InputStream getProduct(ProductType prod, Integer hspecId, String scientificName) throws SQLException, ImageNotFoundException, MalformedURLException, IOException {
        MapItem item = this.getMap(hspecId, scientificName);
        switch (2.$SwitchMap$org$gcube$application$aquamaps$images$model$ProductType[prod.ordinal()]) {
            case 1: {
                logger.debug("Url is " + item.getStaticImageUri());
                return new URL(item.getStaticImageUri()).openStream();
            }
            case 2: {
                return this.getSpeciesPicture(scientificName);
            }
            case 3: {
                String metaId = item.getGeoId();
                logger.debug("GIS ID IS " + metaId);
                if (metaId == null) {
                    throw new ImageNotFoundException();
                }
                try {
                    String rawMeta = this.getGeoNetworkReader().getByIdAsRawString(metaId);
                    return new ByteArrayInputStream(rawMeta.getBytes("UTF-8"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.debug("Unable to read meta with ID " + metaId);
                    throw new ImageNotFoundException();
                }
            }
            case 4: {
                throw new ImageNotFoundException();
            }
        }
        throw new ImageNotFoundException();
    }

    public InputStream getSpeciesPicture(String scientificName) throws SQLException, ImageNotFoundException, MalformedURLException, IOException {
        return new URL("http://www.fishbase.org/images/thumbnails/jpg/tn_" + this.getSpeciesInfo(scientificName).getPic()).openStream();
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public long getCountByHspecId(Integer hspecId) throws SQLException {
        QueryBuilder builder = this.mapDao.queryBuilder();
        return this.mapDao.countOf(builder.setCountOf(true).where().eq("hspecId", (Object)hspecId).prepare());
    }

    public long getSpeciesCount() throws SQLException {
        return this.speciesDao.countOf();
    }

    public long getSpeciesPicCount() throws SQLException {
        QueryBuilder builder = this.speciesDao.queryBuilder();
        return this.speciesDao.countOf(builder.setCountOf(true).distinct().selectColumns(new String[]{"pic"}).where().isNotNull("pic").prepare());
    }

    public InputStream getImageNotFound() {
        return Common.class.getResourceAsStream(this.props.getProperty(IMAGE_NOT_FOUND_FILE));
    }

    public InputStream getHelpStream() {
        return Common.class.getResourceAsStream(this.props.getProperty(HELP_FILE));
    }

    public Dao<MapItem, Integer> getMapDao() {
        return this.mapDao;
    }

    public Dao<SpeciesInfo, String> getSpeciesDao() {
        return this.speciesDao;
    }

    public String getProperty(String property) {
        return this.props.getProperty(property);
    }

    public Long getLastCompletedUpdate() {
        return this.lastCompletedUpdate;
    }

    public void setLastCompletedUpdate(Long lastCompletedUpdate) {
        this.lastCompletedUpdate = lastCompletedUpdate;
    }

    public void setLastConfiguration(Map<String, String> lastConfiguration) {
        logger.debug("Settting last usedConfiguration " + lastConfiguration);
        this.lastConfiguration = lastConfiguration;
        this.lastCompletedUpdate = System.currentTimeMillis();
        try {
            long speciesCount = this.getSpeciesCount();
            long pictureCount = this.getSpeciesPicCount();
            long nativeCount = this.getCountByHspecId(Integer.valueOf(Integer.parseInt(lastConfiguration.get(NATIVE_PROP))));
            long native2050Count = this.getCountByHspecId(Integer.valueOf(Integer.parseInt(lastConfiguration.get(NATIVE_2050_PROP))));
            long suitableCount = this.getCountByHspecId(Integer.valueOf(Integer.parseInt(lastConfiguration.get(SUITABLE_PROP))));
            long suitable2050Count = this.getCountByHspecId(Integer.valueOf(Integer.parseInt(lastConfiguration.get(SUITABLE_2050_PROP))));
            this.statistics = new Statistics(speciesCount, pictureCount, nativeCount, native2050Count, suitableCount, suitable2050Count, this.lastCompletedUpdate.longValue());
        }
        catch (SQLException e) {
            logger.warn("Unable to evaluate statistics", (Throwable)e);
        }
    }

    public synchronized Map<String, String> getLastConfiguration() {
        if (this.lastConfiguration == null || this.lastConfiguration.isEmpty()) {
            this.lastConfiguration = new HashMap();
            this.lastConfiguration.put(NATIVE_PROP, this.getProperty(NATIVE_PROP));
            this.lastConfiguration.put(NATIVE_2050_PROP, this.getProperty(NATIVE_2050_PROP));
            this.lastConfiguration.put(SUITABLE_2050_PROP, this.getProperty(SUITABLE_2050_PROP));
            this.lastConfiguration.put(SUITABLE_PROP, this.getProperty(SUITABLE_PROP));
            this.lastConfiguration.put(FETCH_ROUTINE_INTERVAL_MINUTES, this.getProperty(FETCH_ROUTINE_INTERVAL_MINUTES));
            this.lastConfiguration.put(SCOPE_PROP, this.getProperty(SCOPE_PROP));
            logger.debug("Last configuration is empty, using current... " + this.lastConfiguration);
        }
        return this.lastConfiguration;
    }

    public synchronized boolean insertOrUpdateMapInfoByCoverage(MapItem item) throws SQLException {
        try {
            MapItem found = this.getMap(Integer.valueOf(item.getHspecId()), item.getScientificName());
            found.setSpeciesId(item.getSpeciesId());
            if (item.getStaticImageUri() != null) {
                found.setStaticImageUri(item.getStaticImageUri());
            }
            if (item.getGeoId() != null) {
                found.setGeoId(item.getGeoId());
            }
            this.mapDao.update((Object)found);
            return false;
        }
        catch (ImageNotFoundException e) {
            this.mapDao.create((Object)item);
            return true;
        }
    }

    static /* synthetic */ Properties access$000(Common x0) {
        return x0.props;
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }
}

