/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.images;

import com.j256.ormlite.dao.Dao;
import java.sql.SQLException;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.File;
import org.gcube.application.aquamaps.images.Common;
import org.gcube.application.aquamaps.images.model.SpeciesInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeciesCSVLineProcessor
implements CSVLineProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SpeciesCSVLineProcessor.class);
    long count = 0L;
    int genusIndex = 0;
    int speciesIndex = 0;
    int picnameIndex = 0;
    int speciesIdIndex = 0;
    private Dao<SpeciesInfo, String> speciesDao = Common.get().getSpeciesDao();

    public boolean continueProcessing() {
        return true;
    }

    public void processDataLine(int arg0, List<String> arg1) {
        try {
            String picname = arg1.get(this.picnameIndex);
            String species = arg1.get(this.speciesIndex);
            String genus = arg1.get(this.genusIndex);
            String speciesId = arg1.get(this.speciesIdIndex);
            SpeciesInfo info = new SpeciesInfo(speciesId, picname, new String(String.valueOf(genus) + species).toLowerCase());
            this.speciesDao.createOrUpdate((Object)info);
            ++this.count;
        }
        catch (SQLException e) {
            logger.error("Unable to insert / update " + e.getMessage());
            logger.debug("Exception was ", (Throwable)e);
        }
    }

    public void processHeaderLine(int arg0, List<String> arg1) {
        int i = 0;
        while (i < arg1.size()) {
            String column = arg1.get(i);
            if (column.equals("genus")) {
                this.genusIndex = i;
            } else if (column.equals("species")) {
                this.speciesIndex = i;
            } else if (column.equals("picname")) {
                this.picnameIndex = i;
            } else if (column.equals("speciesid")) {
                this.speciesIdIndex = i;
            }
            ++i;
        }
    }

    public long getCount() {
        return this.count;
    }

    private static final String getEarthURI(List<File> files) {
        for (File f : files) {
            if (!f.getName().equals("Earth")) continue;
            return f.getUuri();
        }
        return "";
    }
}

