/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.enabling.Impl.crawler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.ComputationalInfrastructure;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.xstream.AquaMapsXStream;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.DataManagementCall;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.DataManagementInterface;
import org.gcube.application.aquamaps.enabling.Impl.crawler.CrawlerMode;
import org.gcube.application.aquamaps.enabling.Impl.crawler.PortalCrawler;
import org.gcube.application.aquamaps.enabling.Impl.crawler.ServiceCrawler;
import org.gcube.application.aquamaps.enabling.Impl.crawler.SingleScopeCrawler;
import org.gcube.application.aquamaps.enabling.model.DBDescriptor;
import org.gcube.application.aquamaps.enabling.model.DataSourceDescriptor;
import org.gcube.application.aquamaps.enabling.model.GeoServerDescriptor;
import org.gcube.application.aquamaps.enabling.model.VODescriptor;
import org.gcube.application.aquamaps.enabling.util.Constants;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runninginstance.Endpoint;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;

public abstract class ISCrawler {
    protected static ISClient isClient;
    protected static GCUBELog logger;
    protected GCUBEScope scope = null;
    private GCUBEScope infrastructureScope = null;
    private ConcurrentHashMap<String, VODescriptor> infrastructureMap = new ConcurrentHashMap();
    private static ISCrawler instance;

    public static synchronized ISCrawler get(int minutes, int gcMinutes, boolean enableGCForceing, CrawlerMode mode, GCUBEScope startScope) throws Exception {
        if (instance == null) {
            switch (mode) {
                case PORTAL: {
                    instance = new PortalCrawler(minutes, gcMinutes, enableGCForceing);
                    break;
                }
                case SERVICE: {
                    instance = new ServiceCrawler(minutes, gcMinutes, enableGCForceing);
                    break;
                }
                case SINGLESCOPE: {
                    instance = new SingleScopeCrawler(minutes, gcMinutes, enableGCForceing, startScope);
                }
            }
        }
        return instance;
    }

    private static GCUBEScope getInfrastructure() throws Exception {
        GCUBEScope infrastructureScope = GHNContext.getContext().getStartScopes()[0].getInfrastructure();
        return infrastructureScope;
    }

    protected abstract ArrayList<GCUBEScope> findAvailableScopes(GCUBEScope var1) throws Exception;

    protected VODescriptor getScopeInformation(GCUBEScope scope) throws Exception {
        try {
            logger.debug((Object)("Checking scope : " + scope));
            List<ComputationalInfrastructure> infrastructures = ISCrawler.getEnvironments(scope);
            HashMap<String, String> backendsURL = new HashMap<String, String>();
            HashMap<String, String> serverConfiguration = new HashMap<String, String>();
            for (ComputationalInfrastructure c : infrastructures) {
                String backend = c.getSubmissionBackend();
                List<GCUBERunningInstance> backendsRIs = ISCrawler.getRIsByServiceName(scope, backend);
                if (backendsRIs.size() > 0) {
                    GCUBERunningInstance ri = backendsRIs.get(0);
                    backendsURL.put(ri.getServiceName(), ((Endpoint)ri.getAccessPoint().getRunningInstanceInterfaces().getEndpoint().get(0)).getValue());
                    continue;
                }
                logger.debug((Object)("No RI available for " + backend));
            }
            GCUBERunningInstance RI = null;
            List<GCUBERunningInstance> aquamapsRIs = ISCrawler.getRIsByServiceNameAndClass(scope, "AquaMapsService", "Application");
            if (aquamapsRIs.size() == 0 && this.isCheckRunningInstance()) {
                throw new Exception("NO VALID RI FOUND");
            }
            if (aquamapsRIs.size() > 1) {
                throw new Exception("Multiple AquaMaps RI found on this scope ");
            }
            if (aquamapsRIs.size() == 1) {
                RI = aquamapsRIs.get(0);
                DataManagementInterface dmInterface = DataManagementCall.getCall((GCUBEScope)scope, (String)RI.getAccessPoint().getEndpoint("gcube/application/aquamaps/aquamapsservice/DataManagement").getAddress().toString(), (boolean)false);
                for (Field f : dmInterface.getDefaultSources()) {
                    serverConfiguration.put(f.getName(), f.getValue());
                }
            }
            List<GeoServerDescriptor> geoServers = ISCrawler.getGeoServers(scope);
            List<DataSourceDescriptor> geoNetworks = ISCrawler.getGeoNetwork(scope);
            ArrayList<DBDescriptor> gisDBs = ISCrawler.getGISDataBase(scope);
            ArrayList<DBDescriptor> internalDBs = ISCrawler.getInternalDB(scope);
            ArrayList<DBDescriptor> publisherDBs = ISCrawler.getPublisherDB(scope);
            if (geoNetworks.size() > 1) {
                throw new Exception("Multiple GeoNetworks found");
            }
            if (this.isCheckGisDatabase() && geoServers.size() > 0 && gisDBs.isEmpty()) {
                throw new Exception("No gis databases found");
            }
            if (this.isCheckGisDatabase() && gisDBs.size() > 1) {
                throw new Exception("Found " + gisDBs.size() + " gis DBs");
            }
            if (this.isCheckInternalDB() && internalDBs.size() != 1) {
                throw new Exception("Found " + internalDBs.size() + " internal DBs");
            }
            if (this.isCheckPublisherDatabase() && publisherDBs.size() != 1) {
                throw new Exception("Found " + publisherDBs.size() + " publisher DBs");
            }
            DataSourceDescriptor geoNetwork = geoNetworks.isEmpty() ? null : geoNetworks.get(0);
            DBDescriptor internal = internalDBs.isEmpty() ? null : (DBDescriptor)internalDBs.get(0);
            DBDescriptor publisher = publisherDBs.isEmpty() ? null : (DBDescriptor)publisherDBs.get(0);
            DBDescriptor gisDb = gisDBs.isEmpty() ? null : (DBDescriptor)gisDBs.get(0);
            return new VODescriptor(scope, RI, geoServers, geoNetwork, internal, gisDb, publisher, infrastructures, serverConfiguration, backendsURL);
        }
        catch (Exception e) {
            logger.error((Object)("Unexpected Error while crawling scope " + scope + ", error message : " + e.getMessage()));
            logger.debug((Object)("Instance : " + this.checks()));
            logger.debug((Object)"StackTrace  ", (Throwable)e);
            throw e;
        }
    }

    protected void schedule(int updateMinutes, int gcMinutes, boolean enableGCForcing) {
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ISCrawler.this.forceUpdate();
                }
                catch (Throwable t) {
                    logger.error((Object)"Unexpected Exception while updateing", t);
                }
                finally {
                    logger.trace((Object)("Update routine completed, available scopes are " + ISCrawler.this.infrastructureMap.keySet()));
                }
            }
        }, updateMinutes * 60 * 1000, (long)(updateMinutes * 60 * 1000));
        if (enableGCForcing) {
            t.schedule(new TimerTask(){

                @Override
                public void run() {
                    Runtime.getRuntime().gc();
                }
            }, 0L, (long)(gcMinutes * 60 * 1000));
        }
    }

    public void forceUpdate() throws Exception {
        this.infrastructureScope = ISCrawler.getInfrastructure();
        for (GCUBEScope scope : this.findAvailableScopes(this.infrastructureScope)) {
            try {
                if (scope == null) continue;
                this.infrastructureMap.put(scope.toString(), this.getScopeInformation(scope));
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to crawl through scope " + scope.getName()), (Throwable)e);
            }
        }
    }

    public ConcurrentHashMap<String, VODescriptor> getInfrastructureMap() {
        return this.infrastructureMap;
    }

    protected static List<GCUBERunningInstance> getRIsByServiceName(GCUBEScope scope, String serviceName) throws Exception {
        GCUBERIQuery riQuery = (GCUBERIQuery)isClient.getQuery(GCUBERIQuery.class);
        riQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/ServiceName", serviceName)});
        return isClient.execute((ISQuery)riQuery, scope);
    }

    protected static List<GCUBERunningInstance> getRIsByServiceNameAndClass(GCUBEScope scope, String serviceName, String serviceClass) throws Exception {
        GCUBERIQuery riQuery = (GCUBERIQuery)isClient.getQuery(GCUBERIQuery.class);
        riQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/ServiceName", serviceName)});
        riQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/ServiceClass", serviceClass)});
        return isClient.execute((ISQuery)riQuery, scope);
    }

    protected static List<ComputationalInfrastructure> getEnvironments(GCUBEScope scope) throws Exception {
        ArrayList<ComputationalInfrastructure> toReturn = new ArrayList<ComputationalInfrastructure>();
        GCUBEGenericResourceQuery infrastructureQuery = (GCUBEGenericResourceQuery)isClient.getQuery(GCUBEGenericResourceQuery.class);
        infrastructureQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/SecondaryType", "ComputationalInfrastructure")});
        for (GCUBEGenericResource resource : isClient.execute((ISQuery)infrastructureQuery, scope)) {
            try {
                String body = resource.getBody();
                ComputationalInfrastructure infrastructure = (ComputationalInfrastructure)AquaMapsXStream.getXMLInstance().fromXML(body);
                toReturn.add(infrastructure);
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to parse resource [ID :" + resource.getID() + "]"), (Throwable)e);
            }
        }
        return toReturn;
    }

    protected static List<GeoServerDescriptor> getGeoServers(GCUBEScope scope) throws Exception {
        logger.debug((Object)"Checking geoServers..");
        ArrayList<GeoServerDescriptor> toReturn = new ArrayList<GeoServerDescriptor>();
        GCUBERuntimeResourceQuery runtimeQuery = (GCUBERuntimeResourceQuery)isClient.getQuery(GCUBERuntimeResourceQuery.class);
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Category", Constants.get().getGeoServerCategoryName())});
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Platform/Name", Constants.get().getGeoServerPlatformName())});
        List list = isClient.execute((ISQuery)runtimeQuery, scope);
        for (GCUBERuntimeResource rr : list) {
            try {
                for (AccessPoint access : rr.getAccessPoints()) {
                    if (!access.getEntryname().equals(Constants.get().getGeoServerEntryName())) continue;
                    logger.debug((Object)("Found Access point " + access.getEntryname() + " in " + rr.getName() + " [ ID : " + rr.getID() + "]"));
                    toReturn.add(new GeoServerDescriptor(access.getEndpoint(), access.getUsername(), access.getPassword(), access.getProperty(Constants.get().getGeoServerAquaMapsWorkspace()), access.getProperty(Constants.get().getGeoServerAquaMapsDataStore()), access.getProperty(Constants.get().getGeoServerAquaMapsDefaultDistributionStyle())));
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to parse resource [ID :" + rr.getID() + "]"), (Throwable)e);
            }
        }
        return toReturn;
    }

    protected static List<DataSourceDescriptor> getGeoNetwork(GCUBEScope scope) throws Exception {
        logger.debug((Object)"Checking geoNetwork..");
        ArrayList<DataSourceDescriptor> toReturn = new ArrayList<DataSourceDescriptor>();
        GCUBERuntimeResourceQuery runtimeQuery = (GCUBERuntimeResourceQuery)isClient.getQuery(GCUBERuntimeResourceQuery.class);
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Category", Constants.get().getGeoNetworkCategoryName())});
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Platform/Name", Constants.get().getGeoNetworkPlatformName())});
        List list = isClient.execute((ISQuery)runtimeQuery, scope);
        for (GCUBERuntimeResource rr : list) {
            try {
                for (AccessPoint access : rr.getAccessPoints()) {
                    if (!access.getEntryname().equals(Constants.get().getGeoNetworkEntryName())) continue;
                    logger.debug((Object)("Found Access point " + access.getEntryname() + " in " + rr.getName() + " [ ID : " + rr.getID() + "]"));
                    toReturn.add(new DataSourceDescriptor(access.getEndpoint(), access.getUsername(), access.getPassword()));
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to parse resource [ID :" + rr.getID() + "]"), (Throwable)e);
            }
        }
        return toReturn;
    }

    protected static ArrayList<DBDescriptor> getGISDataBase(GCUBEScope scope) throws Exception {
        logger.debug((Object)"Checking gis DBs");
        ArrayList<DBDescriptor> toReturn = new ArrayList<DBDescriptor>();
        GCUBERuntimeResourceQuery runtimeQuery = (GCUBERuntimeResourceQuery)isClient.getQuery(GCUBERuntimeResourceQuery.class);
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Category", Constants.get().getGeoServerDBCategory())});
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Platform/Name", Constants.get().getGeoServerDBPlatformName())});
        List list = isClient.execute((ISQuery)runtimeQuery, scope);
        for (GCUBERuntimeResource rr : list) {
            try {
                for (AccessPoint access : rr.getAccessPoints()) {
                    if (!access.getEntryname().equals(Constants.get().getGeoServerDBEntryName()) || !access.getAllPropertyNames().contains(Constants.get().getGeoServerDBAquaMapsDataStore()) || !Boolean.parseBoolean(access.getProperty(Constants.get().getGeoServerDBAquaMapsDataStore()))) continue;
                    logger.debug((Object)("Found Access point " + access.getEntryname() + " in " + rr.getName() + " [ ID : " + rr.getID() + "]"));
                    DBDescriptor toAdd = new DBDescriptor(access.getEndpoint(), access.getUsername(), access.getPassword(), DBDescriptor.DBType.postgres, Integer.parseInt(access.getProperty(Constants.get().getDBMaxConnection())));
                    toAdd.setProperty(DBDescriptor.AQUAMAPS_WORLD_TABLE, access.getProperty(DBDescriptor.AQUAMAPS_WORLD_TABLE));
                    toReturn.add(toAdd);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to parse resource [ID :" + rr.getID() + "]"), (Throwable)e);
            }
        }
        return toReturn;
    }

    protected static ArrayList<DBDescriptor> getInternalDB(GCUBEScope scope) throws Exception {
        logger.debug((Object)"Checking internal DBs");
        ArrayList<DBDescriptor> toReturn = new ArrayList<DBDescriptor>();
        GCUBERuntimeResourceQuery runtimeQuery = (GCUBERuntimeResourceQuery)isClient.getQuery(GCUBERuntimeResourceQuery.class);
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Category", Constants.get().getInternalDBCategoryName())});
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Platform/Name", Constants.get().getInternalDBPlatformName())});
        List list = isClient.execute((ISQuery)runtimeQuery, scope);
        for (GCUBERuntimeResource rr : list) {
            try {
                for (AccessPoint access : rr.getAccessPoints()) {
                    if (!access.getEntryname().equals(Constants.get().getInternalDBEntryName()) || !access.getAllPropertyNames().contains(Constants.get().getInternalDBSchemaName()) || !access.getProperty(Constants.get().getInternalDBSchemaName()).equals(Constants.get().getInternalDBSchemaValue())) continue;
                    logger.debug((Object)("Found Access point " + access.getEntryname() + " in " + rr.getName() + " [ ID : " + rr.getID() + "]"));
                    DBDescriptor toAdd = new DBDescriptor(access.getEndpoint(), access.getUsername(), access.getPassword(), DBDescriptor.DBType.postgres, Integer.parseInt(access.getProperty(Constants.get().getDBMaxConnection())));
                    toAdd.setProperty(DBDescriptor.TABLESPACE_PREFIX, access.getProperty(DBDescriptor.TABLESPACE_PREFIX));
                    toAdd.setProperty(DBDescriptor.TABLESPACE_COUNT, access.getProperty(DBDescriptor.TABLESPACE_COUNT));
                    toReturn.add(toAdd);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to parse resource [ID :" + rr.getID() + "]"), (Throwable)e);
            }
        }
        return toReturn;
    }

    protected static ArrayList<DBDescriptor> getPublisherDB(GCUBEScope scope) throws Exception {
        logger.debug((Object)"Checking internal DBs");
        ArrayList<DBDescriptor> toReturn = new ArrayList<DBDescriptor>();
        GCUBERuntimeResourceQuery runtimeQuery = (GCUBERuntimeResourceQuery)isClient.getQuery(GCUBERuntimeResourceQuery.class);
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Category", Constants.get().getPublisherDBCategoryName())});
        runtimeQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Profile/Platform/Name", Constants.get().getPublisherDBPlatformName())});
        List list = isClient.execute((ISQuery)runtimeQuery, scope);
        for (GCUBERuntimeResource rr : list) {
            try {
                for (AccessPoint access : rr.getAccessPoints()) {
                    if (!access.getEntryname().equals(Constants.get().getPublisherDBEntryName()) || !access.getAllPropertyNames().contains(Constants.get().getPublisherDBSchemaName()) || !access.getProperty(Constants.get().getPublisherDBSchemaName()).equals(Constants.get().getPublisherDBSchemaValue())) continue;
                    logger.debug((Object)("Found Access point " + access.getEntryname() + " in " + rr.getName() + " [ ID : " + rr.getID() + "]"));
                    DBDescriptor toAdd = new DBDescriptor(access.getEndpoint(), access.getUsername(), access.getPassword(), DBDescriptor.DBType.postgres, Integer.parseInt(access.getProperty(Constants.get().getDBMaxConnection())));
                    toReturn.add(toAdd);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to parse resource [ID :" + rr.getID() + "]"), (Throwable)e);
            }
        }
        return toReturn;
    }

    protected abstract boolean isCheckInternalDB();

    protected abstract boolean isCheckGisDatabase();

    protected abstract boolean isCheckPublisherDatabase();

    protected abstract boolean isCheckRunningInstance();

    public String checks() {
        StringBuilder builder = new StringBuilder();
        builder.append("INSTANCE : " + this.hashCode());
        builder.append(" [isCheckInternalDB()=");
        builder.append(this.isCheckInternalDB());
        builder.append(", isCheckGisDatabase()=");
        builder.append(this.isCheckGisDatabase());
        builder.append(", isCheckPublisherDatabase()=");
        builder.append(this.isCheckPublisherDatabase());
        builder.append(", isCheckRunningInstance()=");
        builder.append(this.isCheckRunningInstance());
        builder.append("]");
        return builder.toString();
    }

    static {
        logger = new GCUBELog(ISCrawler.class);
        instance = null;
        try {
            isClient = (ISClient)GHNContext.getImplementation(ISClient.class);
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to get ISClient implementation", (Throwable)e);
        }
    }
}

