/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.perform.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.application.perform.service.LocalConfiguration;
import org.gcube.application.perform.service.engine.impl.PerformanceManagerImpl;
import org.gcube.application.perform.service.engine.impl.SchemaDefinition;
import org.gcube.application.perform.service.engine.model.InternalException;
import org.gcube.application.perform.service.engine.model.importer.AnalysisType;
import org.gcube.application.perform.service.engine.model.importer.ImportedTable;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleEvent;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@XmlRootElement(name="perform-lifecycle")
public class PerformServiceLifecycleManager
extends ApplicationLifecycleHandler {
    private static final Logger log = LoggerFactory.getLogger(PerformServiceLifecycleManager.class);

    public void onStart(ApplicationLifecycleEvent.Start e) {
        super.onStart(e);
        try {
            ApplicationContext context = (ApplicationContext)e.context();
            log.debug("Starting Service. ApplicationContext is {} ", (Object)context);
            log.debug("Application is {} ", (Object)context.application());
            URL resourceUrl = context.application().getResource("/WEB-INF/config.properties");
            LocalConfiguration.init((URL)resourceUrl);
            ServletContext ctx = context.application();
            String webinfPath = ctx.getRealPath("/WEB-INF");
            if (Boolean.parseBoolean(LocalConfiguration.getProperty((String)"schema.load"))) {
                PerformServiceLifecycleManager.initSchema((String)webinfPath);
                log.info("Loaded configuration schema : ");
                for (Map.Entry entry : PerformanceManagerImpl.getAnalysisConfiguration().entrySet()) {
                    log.info("Tables registered for {} ", entry.getKey());
                    for (ImportedTable t : (Set)entry.getValue()) {
                        log.info("Table {} : {} [Analysis : {}]", new Object[]{t.getSchema().getRelatedDescription(), t.getTableName(), t.getSchema().getAnalysisEnabled()});
                    }
                }
            } else {
                log.warn("SKIPPING LOADING CONFIGURATION. INVALID BEHAVIOUR IN PRODUCTION ENVIRONMENT.");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to init", ex);
        }
    }

    public void onStop(ApplicationLifecycleEvent.Stop e) {
        super.onStop(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void initSchema(String webinfPath) throws IOException, SQLException, InternalException {
        String configurationPath = webinfPath + "/schema";
        log.info("Reading Analysis Configuration from {} ", (Object)configurationPath);
        File folder = new File(configurationPath);
        for (File analysisFolder : folder.listFiles()) {
            String analysisName = analysisFolder.getName();
            AnalysisType type = new AnalysisType(analysisName, analysisName);
            log.info("Reading from " + analysisFolder.getPath());
            for (File schemaFile : analysisFolder.listFiles()) {
                try (FileInputStream fis = null;){
                    Properties props = new Properties();
                    fis = new FileInputStream(schemaFile);
                    props.load(fis);
                    SchemaDefinition schema = new SchemaDefinition(type, props);
                    PerformanceManagerImpl.importSchema((SchemaDefinition)schema, (String)webinfPath);
                }
            }
        }
    }
}

