/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.perform.service.engine.dm;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.time.Instant;
import org.gcube.application.perform.service.engine.DataBaseManager;
import org.gcube.application.perform.service.engine.PerformanceManager;
import org.gcube.application.perform.service.engine.dm.ImporterMonitor;
import org.gcube.application.perform.service.engine.impl.Queries;
import org.gcube.application.perform.service.engine.model.DBField;
import org.gcube.application.perform.service.engine.model.DBQueryDescriptor;
import org.gcube.application.perform.service.engine.model.importer.ImportRoutineDescriptor;
import org.gcube.application.perform.service.engine.model.importer.ImportStatus;
import org.gcube.data.analysis.dataminermanagercl.server.monitor.DMMonitorListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImporterMonitor
implements DMMonitorListener {
    private static final Logger log = LoggerFactory.getLogger(ImporterMonitor.class);
    private PerformanceManager performance;
    private ImportRoutineDescriptor routine;

    public ImporterMonitor(PerformanceManager performance, ImportRoutineDescriptor routine) {
        this.performance = performance;
        this.routine = routine;
    }

    public void accepted() {
        ImporterMonitor.updateStatus((ImportStatus)ImportStatus.ACCEPTED, (ImportRoutineDescriptor)this.routine);
    }

    public void cancelled() {
        ImporterMonitor.updateStatus((ImportStatus)ImportStatus.CANCELLED, (ImportRoutineDescriptor)this.routine);
    }

    public void complete(double percentage) {
        try {
            this.performance.loadOutputData(this.routine);
            ImporterMonitor.updateStatus((ImportStatus)ImportStatus.COMPLETE, (ImportRoutineDescriptor)this.routine);
            log.debug("Completed monitoring of {} ", (Object)this.routine);
        }
        catch (Throwable t) {
            log.error("Unable to load output data for " + this.routine, t);
            ImporterMonitor.updateStatus((ImportStatus)ImportStatus.FAILED, (ImportRoutineDescriptor)this.routine);
        }
    }

    public void failed(String message, Exception exception) {
        ImporterMonitor.updateStatus((ImportStatus)ImportStatus.FAILED, (ImportRoutineDescriptor)this.routine);
    }

    public void running(double percentage) {
        ImporterMonitor.updateStatus((ImportStatus)ImportStatus.RUNNING, (ImportRoutineDescriptor)this.routine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void updateStatus(ImportStatus status, ImportRoutineDescriptor routine) {
        try {
            log.debug("Updateing status {} for {} ", (Object)status, (Object)routine);
            DataBaseManager db = DataBaseManager.get();
            try (Connection conn = db.getConnection();){
                conn.setAutoCommit(true);
                Instant endTime = null;
                switch (1.$SwitchMap$org$gcube$application$perform$service$engine$model$importer$ImportStatus[status.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        endTime = Instant.now();
                    }
                }
                DBQueryDescriptor queryValues = new DBQueryDescriptor().add((DBField)DBField.ImportRoutine.fields.get("id"), (Object)routine.getId()).add((DBField)DBField.ImportRoutine.fields.get("status"), (Object)status.toString()).add((DBField)DBField.ImportRoutine.fields.get("end_time"), (Object)(endTime != null ? new Timestamp(endTime.toEpochMilli()) : null));
                PreparedStatement psUpdate = Queries.UPDATE_IMPORT_STATUS.get(conn, queryValues);
                psUpdate.executeUpdate();
            }
        }
        catch (Throwable t) {
            log.warn("Unable to update status on database");
            log.debug("Error : ", t);
        }
    }
}

