/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.perform.service.rest;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.application.perform.service.PerformServiceManager;
import org.gcube.application.perform.service.engine.Importer;
import org.gcube.application.perform.service.engine.model.DBField;
import org.gcube.application.perform.service.engine.model.DBQueryDescriptor;
import org.gcube.application.perform.service.engine.model.importer.ImportRequest;
import org.gcube.application.perform.service.engine.model.importer.ImportRoutineDescriptor;
import org.gcube.application.perform.service.rest.Import;
import org.gcube.application.perform.service.rest.InterfaceCommons;
import org.gcube.smartgears.annotations.ManagedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="import")
@ManagedBy(value=PerformServiceManager.class)
public class Import {
    private static final Logger log = LoggerFactory.getLogger(Import.class);
    @Inject
    private Importer importer;

    @POST
    @Produces(value={"application/json"})
    public ImportRoutineDescriptor importExcel(@QueryParam(value="batch_type") String batchType, @QueryParam(value="farmid") Long farmid, @QueryParam(value="source") String sourceFile, @QueryParam(value="source_version") String sourceVersion) {
        InterfaceCommons.checkMandatory((Object)batchType, (String)"batch_type");
        InterfaceCommons.checkMandatory((Object)farmid, (String)"farmid");
        InterfaceCommons.checkMandatory((Object)sourceFile, (String)"source");
        InterfaceCommons.checkMandatory((Object)sourceVersion, (String)"source_version");
        ImportRequest req = new ImportRequest(sourceFile, sourceVersion, batchType, farmid);
        try {
            return this.importer.importExcel(req);
        }
        catch (Throwable t) {
            log.warn("Unexpected Exception on IMPORT " + req, t);
            throw new WebApplicationException("Unexpected Exception.", t, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{farmid}")
    public Response getAll(@PathParam(value="farmid") Long farmid) {
        try {
            List toReturn = this.importer.getDescriptors(new DBQueryDescriptor().add((DBField)DBField.ImportRoutine.fields.get("farmid"), (Object)farmid));
            1 entity = new /* Unavailable Anonymous Inner Class!! */;
            return Response.ok((Object)entity).build();
        }
        catch (Throwable t) {
            log.warn("Unexpected Exception ", t);
            throw new WebApplicationException("Unexpected Exception.", t, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="last/{farmid}")
    public Response getGrouped(@PathParam(value="farmid") Long farmid, @DefaultValue(value="COMPLETE") @QueryParam(value="status") String status) {
        try {
            List toReturn = this.importer.getGroupedDescriptors(new DBQueryDescriptor().add((DBField)DBField.ImportRoutine.fields.get("farmid"), (Object)farmid).add((DBField)DBField.ImportRoutine.fields.get("status"), (Object)status));
            2 entity = new /* Unavailable Anonymous Inner Class!! */;
            return Response.ok((Object)entity).build();
        }
        catch (Throwable t) {
            log.warn("Unexpected Exception ", t);
            throw new WebApplicationException("Unexpected Exception.", t, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

