var vis;

function visual(divID,visualisationFields,width,height) {
	
    var w = width,//Math.max( $(window).width() * 0.85, 960 ),  //width
        h = height,//Math.max( $(window).height() * 0.85, 600 ), //height
        m = 20,                                         //margin
        fields = visualisationFields,
        center = {                                      //gravity center
            x : ( w - m ) / 2,
            y : ( h - m ) / 2
        },
        o,            //opacity scale 
        r,            //radius scale
        z,            //color scale
        g,            //gravity scale
        gravity  = -0.01,//gravity constants
        damper   = 0.2,
        friction = 0.9,
        force = d3       //gravity engine
            .layout
            .force()
            .size([ w - m,
                    h - m ]),
        svg = d3         //container
            .select("#"+divID)
            .append("svg:svg")
            .attr("height", h + "px")
            .attr("width", w + "px"),
        circles,         //data representation
        fromColor = "#FFFF00",//"#0DC2FF",//"#00A6FF",
        toColor = "#0000FF",//"#0000FF",//"#003FFF",
        defaultColor = "#4E86AF",
        fromOpacity = 1,//0.1,
        toOpacity = 1,
        tooltip = CustomTooltip( divID, "bubbles_tooltip", 150 );
    
    function init(jsonData) {
            load( jsonData, function() {
                launch();
//                if(fields["skewFieldName"]==undefined){
//                	fromColor = "#4E86AF";
//                	toColor = "#4E86AF";
//                }
                if(fields["skewFieldName"]!=undefined)
                	legend();
            });
    }


    function load( jsonData, callback ){
            features = jsonData.features;
            features.map( function(d) {
            	d.properties[fields["idFieldName"]] = d.properties[fields["idFieldName"]].replace("\"","").replace("\"","");
                return d;
            });
            
            // Defining the scales
            //radius scaling into this range
            r = d3.scale.linear()
            	//domain from 0 to max value of occurrences
                .domain([ 0,//d3.min(features, function(d) { return d.properties[fields["populationFieldName"]]; }),
                          d3.max(features, function(d) { return d.properties[fields["populationFieldName"]]; })+1 ])
                .range([ 10, (Math.sqrt(width*height)/5)*(20/(jsonData.features.length+15))])//100 ]) //from smaller circle radius to largest -- these are the limits 
                .clamp(true);
            //color scaling into this range
            z = d3.scale.linear()
                .domain([ d3.min(features, function(d) { return d.properties[fields["skewFieldName"]]; }),
                          d3.max(features, function(d) { return d.properties[fields["skewFieldName"]]; }) ])
                .range([ fromColor, toColor ]); //this should be the same as the legend's color 'stop' values
            //opacity scaling into this range
            o = d3.scale.linear()
                .domain([ d3.min(features, function(d) { return d.properties[fields["skewFieldName"]]; }),
                          d3.max(features, function(d) { return d.properties[fields["skewFieldName"]]; }) ])
	            .range([ fromOpacity ,toOpacity]); //this should be the same as the legend's opacity 'stop' values
            
            g = function(d) { return -r(d) * r(d) / 2.5; };
            callback();
    }

    function launch() {

        force.nodes(features);

        circles = svg
            .append("svg:g")
            .attr("id", "circles")
            .selectAll("a")
            .data(force.nodes())
            
        	
        
        // Init all circles at random places on the canvas
        force.nodes().forEach( function(d, i) {
            d.x = Math.random() * w;
            d.y = Math.random() * h;
        });


        
        var node =  circles
        .data(force.nodes())
        .enter().append("circle")
                .attr("r", 0)
                .attr("cx", function(d) { return d.x; })
                .attr("cy", function(d) { return d.y; })
                .attr("fill", function(d) { return fields["skewFieldName"]==undefined ? "#4E86AF": z( d.properties[fields["skewFieldName"]] ); })
                .attr("stroke-width", 2)
                .attr("stroke", function(d) { return fields["skewFieldName"]==undefined ? "#4E86AF": d3.rgb(z( d.properties[fields["skewFieldName"]] )).darker(); })
                .attr("id", function(d) { return d.properties[fields["idFieldName"]]; })
                .style("opacity", function(d) { return 0.5; })
                .on("mouseover", function(d, i) { force.resume(); highlight( d, i, this ); })
                .on("mouseout", function(d, i) { tooltip.hideTooltip(); downlight( d, i, this ); });

      
	    var nodeText = circles//svg.selectAll("g")
	        .data(force.nodes())
	        .enter()
	        .append("text")
	        .attr("x", function(d) { return d.x; })
	        .attr("y", function(d) { return d.y; })
	        .attr("text-anchor", "middle")
	        .style("opacity", 1)
	        .text(function(d) { return d.properties[fields["populationFieldName"]]; });
        	
//        	node.append("title").text(function(d) { return d.properties[fields["idFieldName"]]; });
        	
        d3.selectAll("circle")
            .transition()
            .delay(function(d, i) { return i * 10; })
            .duration( 1000 )
            .attr("r", function(d) { return r( d.properties[fields["populationFieldName"]] ); });

        d3.selectAll("text")
        .transition()
        .delay(function(d, i) { return i * 10; })
        .duration( 1000 )
        .attr("r", function(d) { return r( d.properties[fields["populationFieldName"]] ); });
        

        loadGravity( moveCenter );

        //Loads gravity
        function loadGravity( generator ) {
            force
                .gravity(gravity)
                .charge( function(d) { return g( d.properties[fields["populationFieldName"]] ); })
                .friction(friction)
                .on("tick", function(e) {
                    generator(e.alpha);
                    node
                        .attr("cx", function(d) { return d.x; })
                        .attr("cy", function(d) { return d.y; });
                    nodeText
                    	.attr("x", function(d) { return d.x; })
                    	.attr("y", function(d) { return d.y; });
                }).start();
        }

        //Generates a gravitational point in the middle
        function moveCenter( alpha ) {
            force.nodes().forEach(function(d) {
                d.x = d.x + (center.x - d.x) * (damper + 0.02) * alpha;
                d.y = d.y + (center.y - d.y) * (damper + 0.02) * alpha;
            });
        }
    }
    
    function legend() {

        var linearGradient = svg.append("defs")
                .append("linearGradient")
                .attr("id", "legendGradient")
                .attr("x1", "0%")
                .attr("y1", "0%")
                .attr("x2", "0%")
                .attr("y2", "100%")
                .attr("spreadMethod", "pad");

        linearGradient
            .append("stop")
            .attr("offset", "0%")
            .attr("stop-color", fromColor)
            .attr("stop-opacity", fromOpacity);

        linearGradient
            .append("stop")
            .attr("offset", "100%")
            .attr("stop-color", toColor)
            .attr("stop-opacity", toOpacity);

        var legend = svg.append("g")
                .attr("id", "legend");

        legend
            .append("rect")
            .attr("x", "20")
            .attr("y", "20")
            .attr("width", "20")
            .attr("height", "200")
            .attr("style", "fill:url(#legendGradient);");

        legend
            .append("text")
            .attr("x", 45)
            .attr("y", 30)
            .text("Mostly old");

        legend
            .append("text")
            .attr("x", 45)
            .attr("y", 220)
            .text("Mostly recent");

    }

    function highlight( data, i, element ) {
        d3.select(element).attr( "stroke", "red" );

        var description = data.properties[fields["idFieldName"]],
        	content = '<span class=\"title\"><a>' + data.properties[fields["idFieldName"]] + '</a></span><br/>' + "Total occurences for the period <br>"+panelSelections.fromDate+" to "+panelSelections.toDate+" : "+data.properties[fields["populationFieldName"]] + "<br/>";
        
        tooltip.showTooltip(content, d3.event);
    }

    function downlight( data, i, element ) {
        d3.select(element).attr("stroke", function(d) { return d3.rgb(z( data.properties[fields["skewFieldName"]] )).darker(); });
    }
    
    return {
        init : init,
        force : force
    };
}

