/**
 * Modified from vlandham.github.com/vis/gates/js/CustomTooltip.js
 */
function CustomTooltip( divID, tooltipId, width ) {

	var container = $("#"+divID+"Container");
	var canvas = $("#"+divID);
	
	canvas.children("#"+tooltipId).remove();

	canvas.append("<div class='tooltip' id='" + tooltipId + "'></div>");
    
    var tooltip = canvas.children("#"+tooltipId);

    if(width){
        tooltip.css("width", width);
    }

    tooltip.on("mouseleave", function(e) { hideTooltip(); });

    hideTooltip();

    function showTooltip( content, event ) {
        tooltip
            .html(content)
            .show();
        updatePosition(event);
    }

    function hideTooltip(){
        tooltip.hide();
    }

    function updatePosition( event ) {
        tooltip.css('top', event.clientY-container.position().top + 'px').css('left', event.clientX-container.position().left + 'px');
    }

    return {
        showTooltip: showTooltip,
        hideTooltip: hideTooltip,
        updatePosition: updatePosition
    };
}