
var connectionLinks,
	panelSelections,
	visualisationFields,
	visData,
	dID,
	w,h;

//this is the entry point when the data is provided in GeoJSON format by the caller. 
function doVisualiseJSON(dataJSON, visualisationFieldsJSON, divID, width, height){
	dID = divID;
	w = width;
	h = height;
	visualisationFields = JSON.parse(visualisationFieldsJSON);
	initiateVisualisationJSON(dataJSON, divID);
}


function initiateVisualisationJSON(dataJSON,divID){
	$("#"+divID).children("svg").remove();
	
	vis = visual(divID,visualisationFields, w, h);
//	visualise(connectionLinks,panelSelections.number,panelSelections.fromDate,panelSelections.toDate,panelSelections.order);
	doVisualisation(JSON.parse(dataJSON))
}


//this function is the entry point of this page (it's called from the GXT widget)
function doVisualise(serverLinksJSON, panelSelectionsJSON, visualisationFieldsJSON, divID, width, height){
	dID = divID;
	w = width;
	h = height;
	connectionLinks = JSON.parse(serverLinksJSON);   //undecode JSON-encoded links from server and add them into global connectionLinks
	panelSelections = JSON.parse(panelSelectionsJSON);
	visualisationFields = JSON.parse(visualisationFieldsJSON);
	initiateVisualisation(divID);
}


function initiateVisualisation(divID){
	//remove the previous visualisation
	$("#"+divID).children("svg").remove();
	
	//initiate the visualisation
	vis = visual(divID,visualisationFields, w, h);
	//and do visualise
	visualise(connectionLinks,panelSelections.number,panelSelections.fromDate,panelSelections.toDate,panelSelections.order);


}


function visualise(connectionLinks, rowLimit, fromDate, toDate, sorting){
	var jsonDataLink = connectionLinks["geoserver"]+connectionLinks["workspace"]+"/ows?service=WFS&version=1.0.0&request=GetFeature&typeName="+connectionLinks["workspace"]+":"+connectionLinks["layerName"]+"&maxFeatures="+rowLimit+"&outputFormat=json&viewparams=fromDate:'"+fromDate+"';toDate:'"+toDate+"';order:"+sorting;
	//load the correct JSONdata from geoserver
	ajaxJSONPcall(jsonDataLink,"doVisualisation"); //and the callback does the actual visualisation
}

//the following will serve as a JSONP solution to cross domain http calls
//note that the function name is embedded on the json string returned by the geoserver
function ajaxJSONPcall (url, callbackfunctionName){
	$.ajax({
    	cache : false,
    	type : 'GET',
  //  	async : false,
    	url : url+'&format_options=callback:'+callbackfunctionName,
        dataType: 'jsonp',
        crossDomain : true,
        success: function(data){
        	alert(data);
        },
        failure: function(error){
			alert(error);
        }
    });

}


function doVisualisation(visualisationData){
	visData = visualisationData;
	//this is the actual visualisation
	vis.init(visualisationData);
}

function resizeVisualisation(width,height){
	w = width;
	h = height;
	//remove the previous visualisation
	$("#"+dID).children("svg").remove();
	//initiate the visualisation
	vis = visual(dID,visualisationFields, w, h);
	vis.init(visData);
}
