package org.visualisation.client;

import org.visualisation.client.JS.MyCSSBundle;
import org.visualisation.client.JS.MyJSBundle;
import org.visualisation.client.JS.MyJavaScriptInjector;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.StyleInjector;
import com.google.gwt.json.client.JSONException;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;


public class StaticTools {	
	
	public static String createGeoserverParams(String geoserverUrl, String workspace, String layerName) throws IllegalArgumentException {
		return StaticTools.createJSONConnParams("", "", "", "", layerName, "", "", workspace, geoserverUrl);
	}
	
	
	private static String createJSONConnParams(String featureTypeLink, String dataStore,
			String coverageStore, String resource, String layerName,
			String resourceName, String type, String workspace, String geoserver) {
		JSONObject obj = new JSONObject();
		obj.put("featureTypeLink", new JSONString(featureTypeLink));
		obj.put("dataStore", new JSONString(dataStore));
		obj.put("coverageStore", new JSONString(coverageStore));
		obj.put("resource", new JSONString(resource));
		obj.put("layerName", new JSONString(layerName));
		obj.put("resourceName", new JSONString(resourceName));
		obj.put("type", new JSONString(type));
		obj.put("workspace", new JSONString(workspace));
		obj.put("geoserver", new JSONString(geoserver));
		return obj.toString();
	}
	
	public static String setVisualisationFields(String idFieldName, String populationFieldName, String skewFieldName) throws IllegalArgumentException {
		JSONObject obj = new JSONObject();
		obj.put("idFieldName", new JSONString(idFieldName));
		obj.put("populationFieldName", new JSONString(populationFieldName));
		obj.put("skewFieldName", new JSONString(skewFieldName));
		return obj.toString();
	}
	public static String setVisualisationFields(String idFieldName, String populationFieldName) throws IllegalArgumentException {
		JSONObject obj = new JSONObject();
		obj.put("idFieldName", new JSONString(idFieldName));
		obj.put("populationFieldName", new JSONString(populationFieldName));
		return obj.toString();
	}
	
	
	public static void injectBubblePlotFiles(){
		MyJSBundle bundleJS = GWT.create(MyJSBundle.class);
		MyJavaScriptInjector.inject(bundleJS.jquerymin().getText());
		MyJavaScriptInjector.inject(bundleJS.jqueryui().getText());
		MyJavaScriptInjector.inject(bundleJS.d3v3min().getText());
		MyJavaScriptInjector.inject(bundleJS.bubbleplot().getText());
		MyJavaScriptInjector.inject(bundleJS.customtooltip().getText());
		MyJavaScriptInjector.inject(bundleJS.bubbleplotcode().getText());
		MyCSSBundle bundleCSS = GWT.create(MyCSSBundle.class);
		StyleInjector.inject(bundleCSS.jqueryuicss().getText());
		StyleInjector.inject(bundleCSS.bubbleplotcss().getText());		
	}
	
	public static void injectStaticBubblePlotFiles(){
		MyJSBundle bundleJS = GWT.create(MyJSBundle.class);
		MyJavaScriptInjector.inject(bundleJS.jquerymin().getText());
		MyJavaScriptInjector.inject(bundleJS.jqueryui().getText());
		MyJavaScriptInjector.inject(bundleJS.d3v3min().getText());
		MyJavaScriptInjector.inject(bundleJS.staticbubbleplot().getText());
		MyJavaScriptInjector.inject(bundleJS.staticbubbleplotcode().getText());
		MyCSSBundle bundleCSS = GWT.create(MyCSSBundle.class);
		StyleInjector.inject(bundleCSS.jqueryuicss().getText());
		StyleInjector.inject(bundleCSS.staticbubbleplotcss().getText());
	}
	
	
}
