package org.visualisation.client.bubbles;


import java.awt.Color;

import org.visualisation.client.ControlPanel;
import org.visualisation.client.QueryGeoservers;
import org.visualisation.client.QueryGeoserversAsync;
import org.visualisation.client.StaticTools;
import org.visualisation.client.Date.DatePickerWithYearSelector;
import org.visualisation.client.Date.PopupDatePicker;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.json.client.JSONException;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.sencha.gxt.chart.client.draw.DrawComponent;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.box.AutoProgressMessageBox;
import com.sencha.gxt.widget.core.client.box.MessageBox;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;

/**
 * 
 * @author Nikolas Laskaris
 * creates a GCube widget which will contain a <div> element to display the visualisation
 *
 */
public class BubblePlotCanvas extends FramedPanel {
	
//	private final QueryGeoserversAsync queryGeoservers = GWT.create(QueryGeoservers.class);
	
	private DrawComponent canvas;

	private String canvasID;
	private String widgetID;
	private String width;
	private String height;
	
	
	private void initWidgetSize(){
		canvas.setHeight("auto");
		canvas.setWidth("auto");
		this.setHeight(height);
		this.setWidth(width);
	}
	
	

	private void initWidgetComps(String divID, String width, String height){
		canvasID = divID;
		widgetID = divID+"Container";
		this.width = width;
		this.height = height;
		this.getElement().setId(divID+"Container");
		this.setHeaderVisible(false);
		this.setBodyBorder(false);
		this.setBorders(false);
		canvas = new DrawComponent();
		canvas.getElement().setId(divID);
		setWidget(canvas);
		initWidgetSize();
	}
	
	
	public void redraw(String dataJSON, String idFieldName, String populationFieldName,String skewFieldName){
		String visualisationFields = StaticTools.setVisualisationFields(idFieldName, populationFieldName, skewFieldName);
		doVisualiseJSON(dataJSON, visualisationFields, this.canvasID, this.width, this.height);
	}
	
	
	/**
	 * 
	 * @param dataJSON   the GeoJSON string (if not complying with the GeoJSON standard format, it won't be parsed)
	 * @param idFieldName  the name of the ID property within the GeoJSON string (e.g. if "id":"scientific_name" , then it's 'scientific_name')   
	 * @param populationFieldName similarly to the previous, the population property naming within the GeoJSON string. 
	 * @param skewFieldName  similarly to the previous, the skewness property naming within the GeoJSON string.
	 * @param divID  the divID (unique html document id property) we wish to give to the canvas (in order to search and get it by id)
	 * @param width   the canvas' width
	 * @param height  the canvas' height
	 * 
	 * NOTE: if the GeoJSON string does not contain a skew field, the visualisation will not be the optimal ! Use the other constructor instead. 
	 */
	public BubblePlotCanvas(String dataJSON, String idFieldName, String populationFieldName,String skewFieldName, String divID, String width, String height) {
		this.setBodyStyle("background: white;");
		StaticTools.injectBubblePlotFiles();
		initWidgetComps(divID,width,height);
		try {
			String visualisationFields = StaticTools.setVisualisationFields(idFieldName, populationFieldName, skewFieldName);
			doVisualiseJSON(dataJSON, visualisationFields, this.canvasID, this.width, this.height);
			addResizeListener();
		}
		catch (IllegalArgumentException e) {e.printStackTrace();} 
	}
	
	/**
	 * 
	 * @param dataJSON   the GeoJSON string (if not complying with the GeoJSON standard format, it won't be parsed)
	 * @param idFieldName  the name of the ID property within the GeoJSON string (e.g. if "id":"scientific_name" , then it's 'scientific_name')   
	 * @param populationFieldName similarly to the previous, the population property naming within the GeoJSON string. 
	 * @param divID  the divID (unique html document id property) we wish to give to the canvas (in order to search and get it by id)
	 * @param width   the canvas' width
	 * @param height  the canvas' height
	 * 
	 * NOTE: if the GeoJSON string contains a skew field, it won't be parsed, use the other constructor instead. 
	 */
	
	public BubblePlotCanvas(String dataJSON, String idFieldName, String populationFieldName, String divID, String width, String height) {
		this.setBodyStyle("background: white;");
		StaticTools.injectBubblePlotFiles();
		initWidgetComps(divID,width,height);
		try {
			String visualisationFields = StaticTools.setVisualisationFields(idFieldName, populationFieldName);
			doVisualiseJSON(dataJSON, visualisationFields, this.canvasID, this.width, this.height);
			addResizeListener();
		}
		catch (IllegalArgumentException e) {e.printStackTrace();} 
	}
	
	
	private static native void doVisualiseJSON(String dataJSON, String visualisationFieldsJSON, String canvasID, String width, String height) 
	/*-{
		$wnd.doVisualiseJSON(dataJSON, visualisationFieldsJSON, canvasID, width, height);
	}-*/;
	
	
	private void addResizeListener (){
		this.addResizeHandler(new ResizeHandler() {
			@Override
			public void onResize(ResizeEvent event) {
				width = String.valueOf(event.getWidth());
				height = String.valueOf(event.getHeight());
				resizeVisualisation(width,height);
			}
		});
	}
	
	
	private static native void resizeVisualisation(String width, String height) 
	/*-{
		$wnd.resizeVisualisation(width, height);
	}-*/;
	
}
