package org.visualisation.server;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import org.gcube.common.geoserverinterface.GeoCaller;
import org.gcube.common.geoserverinterface.GeonetworkCaller;
import org.gcube.common.geoserverinterface.GeonetworkCommonResourceInterface.GeoserverMethodResearch;
import org.gcube.common.geoserverinterface.HttpMethodCall;
import org.gcube.common.geoserverinterface.bean.BoundsRest;
import org.gcube.common.geoserverinterface.bean.CswLayersResult;
import org.gcube.common.geoserverinterface.bean.CswRecord;
import org.gcube.common.geoserverinterface.bean.DataStoreRest;
import org.gcube.common.geoserverinterface.bean.FeatureTypeRest;
import org.gcube.common.geoserverinterface.bean.GroupRest;
import org.gcube.common.geoserverinterface.bean.LayerRest;
import org.gcube.common.geoserverinterface.json.JSONException;
import org.gcube.common.geoserverinterface.json.JSONObject;
import org.gcube.common.geoserverinterface.GeoserverCaller;

import org.visualisation.client.QueryGeoservers;
//import com.google.appengine.repackaged.com.google.api.client.util.Data;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;

public class QueryGeoserversImpl extends RemoteServiceServlet implements
		QueryGeoservers {

	private String geoServerLink(String featureTypeLink) {
		return featureTypeLink.split("rest")[0];
	}

	/**
	 * returns the server and layer information in json format
	 */

	public String getGeoserverParamsForLayer(String layerName) throws IllegalArgumentException {
		
		String geonetworkUrl = "http://geoserver.d4science-ii.research-infrastructures.eu/geonetwork";
		String geonetworkUsername = "admin";
		String geonetworkPassword = "admin";
		
		String geoserverUrl = "http://geoserver2.d4science.research-infrastructures.eu/geoserver";
		String geoserverUsername = "admin";
		String geoserverPassword = "gcube@geo2010";
		
		//select the geo network choice method for writing layers
		GeoserverMethodResearch geoserverMethodReserch = GeoserverMethodResearch.MOSTUNLOAD;
//		GeoserverMethodResearch geoserverMethodReserch = GeoserverMethodResearch.RANDOM;
		
		GeoCaller geoCaller = null;
		String featureTypeLink = null, 
				dataStore = null,
				coverageStore = null, 
				resource = null, 
				name = null, 
				resourceName = null, 
				type = null,
				workspace = null, 
				geoserver = null;
		String result = null;
		
		try {
			//instantiate a new Geo network caller with a geoserver failover	
			geoCaller = new GeoCaller(geonetworkUrl, geonetworkUsername, geonetworkPassword, geoserverUrl, geoserverUsername, geoserverPassword, geoserverMethodReserch);
			geoCaller.setWmsGeoserver(geoserverUrl, geoserverUsername, geoserverPassword);
			LayerRest animalia_fishbase = geoCaller.getLayer(layerName);			
			
			featureTypeLink = animalia_fishbase.getFeatureTypeLink();
			dataStore = animalia_fishbase.getDatastore();
			coverageStore = animalia_fishbase.getCoveragestore();			
			resource = animalia_fishbase.getResource();
			name = animalia_fishbase.getName();
			resourceName = animalia_fishbase.getResourceName();
			type = animalia_fishbase.getType();
			workspace = animalia_fishbase.getWorkspace();
			geoserver = geoServerLink(featureTypeLink);
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		try {
			result = createJSONConnParams(featureTypeLink, dataStore, coverageStore, resource, name, resourceName, type, workspace, geoserver);
		} catch (JSONException e) {e.printStackTrace();	}
		
		return result;
	}
	
	private static String createJSONConnParams(String featureTypeLink, String dataStore,
			String coverageStore, String resource, String name,
			String resourceName, String type, String workspace, String geoserver) throws JSONException {
		JSONObject obj = new JSONObject();
		obj.put("featureTypeLink", featureTypeLink);
		obj.put("dataStore", dataStore);
		obj.put("coverageStore", coverageStore);
		obj.put("resource", resource);
		obj.put("layerName", name);
		obj.put("resourceName", resourceName);
		obj.put("type", type);
		obj.put("workspace", workspace);
		obj.put("geoserver", geoserver);
		return obj.toString();
	}
	
	

}
