var visualisation;

function staticbubbleplot(divID, width, height){
	
    var w = width,
	    h = height,
	    diameter = (width+height)/2,
	    m = 20,       //margin
	    dID = divID,
	    o,            //opacity scale 
	    r,            //radius scale
	    z,            //color scale
	    svg,
	    circles,         //data representation
	    fromColor = "#FFFF00",//"#0DC2FF",//"#00A6FF",
	    toColor = "#0000FF",//"#0000FF",//"#003FFF",
	    fromOpacity = 1,//0.1,
	    toOpacity = 1,
    	format,
    	features,
    	color;
	
    function visualise(jsonData){
        features = jsonData.features;
        features.map( function(d) {
        	d.properties.scientific_name = d.properties.scientific_name.replace("\"","").replace("\"","");
            return d;
        });
        // Defining the scales
        //radius scaling into this range
        r = d3.scale.linear()
        	//domain from 0 to max value of occurrences
            .domain([ 0,//d3.min(features, function(d) { return d.properties.occurrences; }),
                      d3.max(features, function(d) { return d.properties.occurrences; })+1 ])
            .range([ 10, (Math.sqrt(width*height)/5)*(20/(jsonData.features.length+15))])//100 ]) //from smaller circle radius to largest -- these are the limits 
            .clamp(true);
        //color scaling into this range
        z = d3.scale.linear()
            .domain([ d3.min(features, function(d) { return d.properties.skew; }),
                      d3.max(features, function(d) { return d.properties.skew; }) ])
            .range([ fromColor, toColor ]); //this should be the same as the legend's color 'stop' values
        //opacity scaling into this range
        o = d3.scale.linear()
            .domain([ d3.min(features, function(d) { return d.properties.skew; }),
                      d3.max(features, function(d) { return d.properties.skew; }) ])
            .range([ fromOpacity ,toOpacity]); //this should be the same as the legend's opacity 'stop' values    
	    
    	format = d3.format(",d");
    	color = d3.scale.category20c();
    	
    	
    	var svg = d3.select("#"+dID).append("svg")
        .attr("width", w)
        .attr("height", h)
        .attr("class", "bubble");
    	
    	
		var bubble = d3.layout.pack()
		     .sort(null)
		     .size([w, h])
		     .padding(1.5);
		
		
		var bubbles = bubble
			.nodes(features)
			.enter().append("circle")
	    	.attr("class", "node");
		
		
		
		var node = svg.selectAll(".node")
//			.data(bubble.nodes)
//		    .data(bubble.nodes(classes(features)))
		  	.data(features)
		    .enter().append("g")
		    .attr("class", "node")
			.attr("transform", function(d) { return "translate(" + d.x + "," + d.y + ")"; });
		
		
		
		node.append("title")
		    .text(function(d) { return d.properties.occurrences + ": " + d.properties.occurrences; });
		
		node.append("circle")
		    .attr("r", function(d) { return r( d.properties.occurrences ); })
            .attr("fill", function(d) { return z( d.properties.skew ); })
            .attr("stroke-width", 2)
            .attr("stroke", function(d) { return d3.rgb(z( d.properties.skew )).darker(); })
            .attr("id", function(d) { return d.properties.scientific_name; })
		    .style("fill", function(d) { return z( d.properties.skew ); });
		
		node.append("text")
		    .attr("dy", ".3em")
		    .style("text-anchor", "middle")
		    .text(function(d) { return d.properties.scientific_name.substring(0, d.r / 3); });
    }
    
    return {
    	visualise:visualise
    }
    
}




