package org.visualisation.client.bubbles;


import java.awt.Color;

import org.visualisation.client.ControlPanel;
import org.visualisation.client.QueryGeoservers;
import org.visualisation.client.QueryGeoserversAsync;
import org.visualisation.client.StaticTools;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.json.client.JSONException;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.sencha.gxt.chart.client.draw.DrawComponent;
import com.sencha.gxt.widget.core.client.Dialog;
import com.sencha.gxt.widget.core.client.box.MessageBox;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;

/**
 * 
 * @author Nikolas Laskaris
 * creates a GCube widget which will contain a <div> element to display the visualisation
 *
 */
public class BubblePlotDialog extends Dialog {
	
	private final QueryGeoserversAsync queryGeoservers = GWT.create(QueryGeoservers.class);
	
	private ControlPanel panel;
	private DrawComponent canvas;
	private VerticalPanel verticalPanel;

	private String canvasID;
	private String widgetID;
	private String width;
	private String height;
	
	
	/**
	 * The layer should return a GeoJSON string with at least the following values (in json path): 
	 * features.id
	 * features.properties.occurrences
	 * features.properties.skew
	 * features.properties.scientific_name
	 * 
	 * @param layerName e.g. "count_occurences_skew"
	 * @param divID the divID we wish to have for the visualisation canvas
	 * @param width  the widget width
	 * @param height the widget height
	 */
	public BubblePlotDialog(String layerName, String idFieldName, String populationFieldName,String skewFieldName, String divID, String width, String height) {
		this.setBodyStyle("background: white;");
		setHideOnButtonClick(true);
		StaticTools.injectBubblePlotFiles();
		initWidgetComps(divID,width,height);
		String visualisationFields = StaticTools.setVisualisationFields(idFieldName, populationFieldName, skewFieldName);
		load(layerName,visualisationFields);
	}
	
	
	public void load(String layerName,final String visualisationFields){
		queryGeoservers.getGeoserverParamsForLayer(layerName,  new AsyncCallback<String>() {
				public void onFailure(Throwable caught) {
					DialogBox dialog = new DialogBox();
//					dialog.setPopupPosition(Window..getClientWidth()/2,Window.getClientHeight()/2);
					dialog.setText("Error");
					dialog.setWidget(new HTMLPanel(caught.toString()));
					dialog.setVisible(true);
					dialog.show();
				}
				public void onSuccess(final String resultJSON) {
					show();
					panel.getSubmitButton().addSelectHandler(new SelectHandler() {
						@Override
						public void onSelect(SelectEvent event) {
							if(!panel.areAllSet()){
								MessageBox message = new MessageBox("Message","Please set all values");
								message.center();
								message.show();
								return;
							}
							try {
								loadVisualisation(resultJSON,panel.getPanelValuesJSON(),visualisationFields);
							} catch (JSONException e) {
								e.printStackTrace();
							}
							
						}
					});
				}
			});
	}
	
	
	private void initWidgetSize(){
		panel.setWidth("auto");
		canvas.setHeight("auto");
		canvas.setWidth("auto");
		this.setHeight(height);
		this.setWidth(width);
	}
	
	

	private void initWidgetComps(String divID, String width, String height){
		canvasID = divID;
		widgetID = divID+"Container";
		this.width = width;
		this.height = height;
		this.getElement().setId(divID+"Container");
		canvas = new DrawComponent();
		canvas.getElement().setId(divID);
		verticalPanel = new VerticalPanel();
		panel = new ControlPanel();
		verticalPanel.add(panel);
		verticalPanel.add(canvas);
		setWidget(verticalPanel);	
		initWidgetSize();
	}
	
	
	/** When we already know the parameters, that means actually no search, but just feed the values in json !
	 * 
	 * @param geoserverUrl  e.g: http://geoserver2.d4science.research-infrastructures.eu/geoserver/
	 * @param workspace
	 * @param layerName
	 * @param divID
	 * @param width
	 * @param height
	 */
	public BubblePlotDialog(String geoserverUrl, String workspace, String layerName, String idFieldName, String populationFieldName,String skewFieldName, String divID, String width, String height) {
		this.setBodyStyle("background: white;");
		setHideOnButtonClick(true);
		StaticTools.injectBubblePlotFiles();
		initWidgetComps(divID,width,height);
		try {
			String visualisationFields = StaticTools.setVisualisationFields(idFieldName, populationFieldName, skewFieldName);
			load(geoserverUrl,workspace,layerName,visualisationFields);
		}
		catch (IllegalArgumentException e) {e.printStackTrace();} 
	}
	
	
	
	
	
	public void load(String geoserverUrl, String workspace, String layerName, final String visualisationFields ) throws IllegalArgumentException{
		final String connParamsJSON = StaticTools.createGeoserverParams(geoserverUrl, workspace, layerName);
		show();
		panel.getSubmitButton().addSelectHandler(new SelectHandler() {
			@Override
			public void onSelect(SelectEvent event) {
				if(!panel.areAllSet()){
					MessageBox message = new MessageBox("Message","Please set all values");
					message.center();
					message.show();
					return;
				}
				try {
					loadVisualisation(connParamsJSON,panel.getPanelValuesJSON(),visualisationFields);
				} catch (JSONException e) {e.printStackTrace();}
			}
		});
	}
	
	
	private void loadVisualisation(String serverLinksJSON, String panelJSONValues, String visualisationFieldsJSON){
		doVisualise(serverLinksJSON, panelJSONValues, visualisationFieldsJSON, this.canvasID, this.width, this.height);
		addResizeListener();
	}
	
	private static native void doVisualise(String serverLinksJSON, String panelSelections, String visualisationFieldsJSON, String canvasID, String width, String height) 
	/*-{
		$wnd.doVisualise(serverLinksJSON, panelSelections, visualisationFieldsJSON, canvasID, width, height);
	}-*/;
	
	
	private void addResizeListener (){
		this.addResizeHandler(new ResizeHandler() {
			@Override
			public void onResize(ResizeEvent event) {
				width = String.valueOf(event.getWidth());
				height = String.valueOf(event.getHeight());
				resizeVisualisation(width,height);
			}
		});
	}
	
	
	private static native void resizeVisualisation(String width, String height) 
	/*-{
		$wnd.resizeVisualisation(width, height);
	}-*/;
	
}
