/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanager.transport;

import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.gcube.application.speciesmanager.stubs.writers.AbstractWrapper;

public class LocalWrapper
extends AbstractWrapper {
    private String locator = UUID.randomUUID().toString();
    private ArrayBlockingQueue<String> queue = new ArrayBlockingQueue(100);
    private static HashMap<String, ArrayBlockingQueue<String>> mapQueues = new HashMap();
    private int links;

    public LocalWrapper() {
        mapQueues.put(this.locator, this.queue);
    }

    public String getLocator() throws Exception {
        return this.locator;
    }

    public synchronized boolean add(String input) throws Exception {
        return this.queue.offer(input, 60L, TimeUnit.SECONDS);
    }

    public void close() throws Exception {
        mapQueues.remove(this.locator);
    }

    protected static ArrayBlockingQueue<String> getQueueFromLocator(String locator) {
        return mapQueues.get(locator);
    }

    public synchronized void unregister() throws Exception {
        if (this.links > 1) {
            --this.links;
        } else {
            this.links = 0;
            this.close();
        }
    }

    public synchronized void register() {
        ++this.links;
    }
}

