package org.gcube.application.speciesmanager.stubs.calls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.speciesmanager.stubs.ManagerPortType;
import org.gcube.application.speciesmanager.stubs.SearchByCommonNameRequest;
import org.gcube.application.speciesmanager.stubs.SearchByScientificNameRequest;
import org.gcube.application.speciesmanager.stubs.model.ResultItem;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Property;
import org.gcube.application.speciesmanager.stubs.readers.ResultItemReader;
import org.gcube.application.speciesmanager.stubs.service.ManagerServiceAddressingLocator;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;

import com.thoughtworks.xstream.XStream;

public class ManagerCalls extends Call{

	private ManagerPortType managerPT;
	
	private GCUBEScope scope;

	/**
	 * the ManagerCalls constructor
	 * 
	 * @param scope
	 * @param securityManager
	 * @throws Exception
	 */
	public ManagerCalls(GCUBEScope scope, GCUBESecurityManager ... securityManager)
			throws Exception {
		this.scope = scope;
		managerPT= new ManagerServiceAddressingLocator().getManagerPortTypePort(getEPR());
		managerPT= GCUBERemotePortTypeContext.getProxy(managerPT, scope, securityManager);
	}

	protected String getPortTypeName() {
		return "gcube/application/speciesmanager/manager";
	}

	private EndpointReferenceType getEPR() throws Exception{
		ISClient client = GHNContext.getImplementation(ISClient.class);
		GCUBERIQuery query =  client.getQuery(GCUBERIQuery.class);
		query.addAtomicConditions(new AtomicCondition("//ServiceName", this.getServiceName()), new AtomicCondition("//ServiceClass", this.getServiceClass()));
		List<GCUBERunningInstance> ris= client.execute(query, this.scope);
		if (ris.size()>0) return ris.get(0).getAccessPoint().getEndpoint(getPortTypeName());
		//add a real exception (NoResoultFoundException)
		else throw new Exception("EPR not found, the service is not ready");
	}
	
	
	/**
	 * 
	 * @param scientificName the sentific name to search 
	 * @param a list of {@link Property} for search filtering
	 * @return an iterator over {@link ResultItem}
	 * @throws Exception
	 */
	public Iterator<ResultItem> searchByScientificName(String scientificName, Property ... props) throws Exception{
		List<String> properties= new ArrayList<String>();
		if (props!=null && props.length>0){
			XStream xstream = new XStream();
			for(Property prop: props)
				properties.add(xstream.toXML(prop));
		}
		return new ResultItemReader(managerPT.searchByScientificName(new SearchByScientificNameRequest(null, properties.toArray(new String[0]), scientificName)));
	}
	
	/**
	 * 
	 * @param commonName the commonName to search
	 * @param props
	 * @return an iterator over {@link ResultItem}
	 * @throws Exception
	 */
	public Iterator<ResultItem> searchByCommonName(String commonName, Property ... props) throws Exception{
		List<String> properties= new ArrayList<String>();
		if (props!=null && props.length>0){
			XStream xstream = new XStream();
			for(Property prop: props)
				properties.add(xstream.toXML(prop));
		}
		return new ResultItemReader(managerPT.searchByCommonName(new SearchByCommonNameRequest(commonName, null , properties.toArray(new String[0]))));
	}
}
