package org.gcube.application.speciesmanager.stubs.calls;

import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.speciesmanager.stubs.OccurrencesPortType;
import org.gcube.application.speciesmanager.stubs.readers.OccurrencesReader;
import org.gcube.application.speciesmanager.stubs.service.OccurrencesServiceAddressingLocator;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;



public class OccurrencesCall extends Call{

	private OccurrencesPortType occurrencePT;
	
	private GCUBEScope scope;

	
	public OccurrencesCall(GCUBEScope scope, GCUBESecurityManager ... securityManager)
			throws Exception {
		this.scope = scope;
		occurrencePT= new OccurrencesServiceAddressingLocator().getOccurrencesPortTypePort(getEPR());
		occurrencePT= GCUBERemotePortTypeContext.getProxy(occurrencePT, scope, securityManager);
	}

	protected String getPortTypeName() {
		return "gcube/application/speciesmanager/occurrences";
	}

	private EndpointReferenceType getEPR() throws Exception{
		ISClient client = GHNContext.getImplementation(ISClient.class);
		GCUBERIQuery query =  client.getQuery(GCUBERIQuery.class);
		query.addAtomicConditions(new AtomicCondition("//ServiceName", this.getServiceName()), new AtomicCondition("//ServiceClass", this.getServiceClass()));
		List<GCUBERunningInstance> ris= client.execute(query, this.scope);
		if (ris.size()>0) return ris.get(0).getAccessPoint().getEndpoint(getPortTypeName());
		//add a real exception (NoResultFoundException)
		else throw new Exception("EPR not found, the service is not ready");
	}
	
	public OccurrencesReader getByIds(String keysLocator) throws Exception{
		return new OccurrencesReader(occurrencePT.getByIds(keysLocator));
	}
	
	public String getLayerByIds(String keysLocator) throws Exception{
		return occurrencePT.getLayerByIds(keysLocator);
	}

}
