package org.gcube.application.speciesmanager.stubs.model;

import java.util.Calendar;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;


@XmlRootElement
@XmlAccessorType(XmlAccessType.NONE)
public class Occurrence {
	
	
	@XmlAttribute(required=true)
	private String institutionCode;
	@XmlAttribute(required=true)
	private String collectionCode;
	@XmlAttribute(required=true)
	private String catalogueNumber;
	@XmlAttribute(required=true)
	private String recordedBy;
	@XmlAttribute(required=true)
	private Calendar eventDate;
	@XmlAttribute
	private Calendar modified;
	@XmlAttribute(required=true)
	private String scientificName;
	@XmlAttribute
	private String kingdom;
	@XmlAttribute
	private String family;
	@XmlAttribute(required=true)
	private String locality;
	@XmlAttribute
	private String country;
	@XmlAttribute
	private String citation;
	@XmlAttribute(required=true)
	private double decimalLatitude;
	@XmlAttribute(required=true)
	private double decimalLongitude;
	@XmlAttribute
	private String coordinateUncertaintyInMeters;
	@XmlAttribute
	private double maxDepth;
	@XmlAttribute
	private double minDepth;
	@XmlAttribute(required=true)
	private BasisOfRecord basisOfRecord;
	
	
	
	public String getCitation() {
		return citation;
	}
	public void setCitation(String citation) {
		this.citation = citation;
	}
	public String getCountry() {
		return country;
	}
	public void setCountry(String country) {
		this.country = country;
	}
	public String getInstitutionCode() {
		return institutionCode;
	}
	public void setInstitutionCode(String institutionCode) {
		this.institutionCode = institutionCode;
	}
	public String getCollectionCode() {
		return collectionCode;
	}
	public void setCollectionCode(String collectionCode) {
		this.collectionCode = collectionCode;
	}
	public String getRecordedBy() {
		return recordedBy;
	}
	public void setRecordedBy(String recordedBy) {
		this.recordedBy = recordedBy;
	}
	public Calendar getEventDate() {
		return eventDate;
	}
	public void setEventDate(Calendar eventDate) {
		this.eventDate = eventDate;
	}
	public String getScientificName() {
		return scientificName;
	}
	public void setScientificName(String scientificName) {
		this.scientificName = scientificName;
	}
	public String getKingdom() {
		return kingdom;
	}
	public void setKingdom(String kingdom) {
		this.kingdom = kingdom;
	}
	public String getFamily() {
		return family;
	}
	public void setFamily(String family) {
		this.family = family;
	}
	public String getLocality() {
		return locality;
	}
	public void setLocality(String locality) {
		this.locality = locality;
	}
	public double getDecimalLatitude() {
		return decimalLatitude;
	}
	public void setDecimalLatitude(double decimalLatitude) {
		this.decimalLatitude = decimalLatitude;
	}
	public double getDecimalLongitude() {
		return decimalLongitude;
	}
	public void setDecimalLongitude(double decimalLongitude) {
		this.decimalLongitude = decimalLongitude;
	}
	public String getCoordinateUncertaintyInMeters() {
		return coordinateUncertaintyInMeters;
	}
	public void setCoordinateUncertaintyInMeters(String coordinateUncertaintyInMeters) {
		this.coordinateUncertaintyInMeters = coordinateUncertaintyInMeters;
	}
	public BasisOfRecord getBasisOfRecord() {
		return basisOfRecord;
	}
	public void setBasisOfRecord(BasisOfRecord basisOfRecord) {
		this.basisOfRecord = basisOfRecord;
	}
	public double getMaxDepth() {
		return maxDepth;
	}
	public void setMaxDepth(double maxDepth) {
		this.maxDepth = maxDepth;
	}
	public double getMinDepth() {
		return minDepth;
	}
	public void setMinDepth(double minDepth) {
		this.minDepth = minDepth;
	}
	
	public Calendar getModified() {
		return modified;
	}
	public void setModified(Calendar modified) {
		this.modified = modified;
	}
	
	public String getCatalogueNumber() {
		return catalogueNumber;
	}
	public void setCatalogueNumber(String catalogueNumber) {
		this.catalogueNumber = catalogueNumber;
	}

	

	public String toString(){
		StringBuilder toReturn = new StringBuilder();
		toReturn.append("[latitide: "+decimalLatitude+"]");
		toReturn.append("[longitude: "+decimalLongitude+"]");
		toReturn.append("[mindepth: "+minDepth+"]");
		toReturn.append("[maxdepth: "+maxDepth+"]");
		toReturn.append("[country: "+country+"]");
		toReturn.append("[locality: "+locality+"]");
		toReturn.append("[catalogueNumber: "+catalogueNumber+"]");
		toReturn.append("[basisOfRecord: "+basisOfRecord.name()+"]");
		return toReturn.toString();
	}

}
