package org.gcube.application.speciesmanager.stubs.writers;

import org.gcube.application.speciesmanager.stubs.model.Occurrence;
import org.gcube.application.speciesmanager.stubs.model.binding.Bindings;
import org.gcube.common.core.utils.logging.GCUBELog;

public class OccurrenceWriter extends AbstractWriter<Occurrence>{

	private GCUBELog logger = new GCUBELog(Occurrence.class);
	
	private String repositoryProvider;
	
		
	public OccurrenceWriter(AbstractWrapper wrapper, String repositoryProvider) {
		super(wrapper);
		this.repositoryProvider = repositoryProvider;
	}

	@Override
	public boolean put(Occurrence t) {
		try{
			return getWrapper().add(Bindings.toXml(t));
		}catch (Exception e) {
			logger.error("error putting the object",e);
			return false;
		}
	}

	
}
