/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanager.parser;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.gcube.application.speciesmanager.stubs.model.BasisOfRecord;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DarwinRecord {
    public int globalUniqueIdentifier;
    public Calendar dateLastModified;
    public BasisOfRecord basisOfRecord;
    public String institutionCode;
    public String collectionCode;
    public String catalogNumber;
    public String remarks;
    public String scientificName;
    public String kingdom;
    public String phylum;
    public String clazz;
    public String order;
    public String family;
    public String genus;
    public String specificEpithet;
    public String infraspecificEpithet;
    public String authorYearOfScientificName;
    public String continent;
    public String country;
    public String stateProvince;
    public String offshore;
    public int minimumElevationInMeters;
    public int maximumElevationInMeters;
    public int minimumDepthInMeters;
    public int maximumDepthInMeters;
    public String dayOfYear;
    public String collector;
    public String sex;
    public double decimalLatitude;
    public double decimalLongitude;
    public double verbatimLatitude;
    public double verbatimLongitude;
    public String identifiedBy;
    public String collectorNumber;
    public String fieldNumber;
    public String typeStatus;
    public String individualCount;
    public static SimpleDateFormat df = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");

    public DarwinRecord(Element eElement) {
        this.globalUniqueIdentifier = Integer.parseInt(DarwinRecord.getTagValue("dwcore:GlobalUniqueIdentifier", eElement));
        this.scientificName = DarwinRecord.getTagValue("dwcore:ScientificName", eElement);
        this.authorYearOfScientificName = DarwinRecord.getTagValue("dwcore:AuthorYearOfScientificName", eElement);
        this.basisOfRecord = BasisOfRecord.valueOf((String)DarwinRecord.getTagValue("dwcore:BasisOfRecord", eElement));
        this.catalogNumber = DarwinRecord.getTagValue("dwcore:CatalogNumber", eElement);
        this.clazz = DarwinRecord.getTagValue("dwcore:Class", eElement);
        this.collectionCode = DarwinRecord.getTagValue("dwcore:CollectionCode", eElement);
        this.collector = DarwinRecord.getTagValue("dwcore:Collector", eElement);
        this.collectorNumber = DarwinRecord.getTagValue("dwcur:CollectorNumber", eElement);
        this.continent = DarwinRecord.getTagValue("dwcore:Continent", eElement);
        this.country = DarwinRecord.getTagValue("dwcore:Country", eElement);
        String dateL = DarwinRecord.getTagValue("dwcore:DateLastModified", eElement).replace("T", " ");
        try {
            Calendar dateC;
            this.dateLastModified = dateC = DarwinRecord.dateString2Calendar(dateL);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        this.dayOfYear = DarwinRecord.getTagValue("dwcore:DayOfYear", eElement);
        this.family = DarwinRecord.getTagValue("dwcore:Family", eElement);
        this.fieldNumber = DarwinRecord.getTagValue("dwcur:FieldNumber", eElement);
        this.genus = DarwinRecord.getTagValue("dwcore:Genus", eElement);
        this.identifiedBy = DarwinRecord.getTagValue("dwcur:IdentifiedBy", eElement);
        this.individualCount = DarwinRecord.getTagValue("dwcur:IndividualCount", eElement);
        this.infraspecificEpithet = DarwinRecord.getTagValue("dwcore:InfraspecificEpithet", eElement);
        this.institutionCode = DarwinRecord.getTagValue("dwcore:InstitutionCode", eElement);
        this.kingdom = DarwinRecord.getTagValue("dwcore:Kingdom", eElement);
        this.offshore = DarwinRecord.getTagValue("dwcore:offshore", eElement);
        this.order = DarwinRecord.getTagValue("dwcore:Order", eElement);
        this.phylum = DarwinRecord.getTagValue("dwcore:Phylum", eElement);
        this.remarks = DarwinRecord.getTagValue("dwcore:Remarks", eElement);
        this.sex = DarwinRecord.getTagValue("dwcore:Sex", eElement);
        this.specificEpithet = DarwinRecord.getTagValue("dwcore:SpecificEpithet", eElement);
        this.stateProvince = DarwinRecord.getTagValue("dwcore:StateProvince", eElement);
        this.typeStatus = DarwinRecord.getTagValue("dwcore:TypeStatus", eElement);
        try {
            this.decimalLatitude = Double.parseDouble(DarwinRecord.getTagValue("dwgeo:DecimalLatitude", eElement));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.decimalLongitude = Double.parseDouble(DarwinRecord.getTagValue("dwgeo:DecimalLongitude", eElement));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.maximumDepthInMeters = Integer.parseInt(DarwinRecord.getTagValue("dwcore:MaximumDepthInMeters", eElement));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.maximumElevationInMeters = Integer.parseInt(DarwinRecord.getTagValue("dwcore:MaximumElevationInMeters", eElement));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.minimumDepthInMeters = Integer.parseInt(DarwinRecord.getTagValue("dwcore:MinimumDepthInMeters", eElement));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.minimumElevationInMeters = Integer.parseInt(DarwinRecord.getTagValue("dwcore:MinimumElevationInMeters", eElement));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.verbatimLatitude = Double.parseDouble(DarwinRecord.getTagValue("dwgeo:VerbatimLatitude", eElement));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.verbatimLongitude = Double.parseDouble(DarwinRecord.getTagValue("dwgeo:VerbatimLongitude", eElement));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static String getTagValue(String sTag, Element eElement) {
        Node nValue;
        NodeList textFNList;
        Element xmlNode;
        String a = "";
        NodeList nlList = eElement.getElementsByTagName(sTag);
        if (nlList != null && (xmlNode = (Element)nlList.item(0)) != null && (textFNList = xmlNode.getChildNodes()) != null && (nValue = textFNList.item(0)) != null) {
            a = nValue.getNodeValue();
        }
        return a;
    }

    private static Calendar dateString2Calendar(String s) throws ParseException {
        Calendar cal = Calendar.getInstance();
        Date d1 = df.parse(s);
        cal.setTime(d1);
        return cal;
    }
}

